/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.unitils.core.ConfigurationLoader;
import org.unitils.core.Module;
import org.unitils.core.ModulesLoader;
import org.unitils.core.ModulesRepository;
import org.unitils.core.TestContext;
import org.unitils.core.TestListener;

public class Unitils {
    private static Unitils unitils;
    private TestListener testListener;
    private ModulesRepository modulesRepository;
    private Properties configuration;
    private TestContext testContext = new TestContext();

    public static synchronized Unitils getInstance() {
        if (unitils == null) {
            Unitils.initSingletonInstance();
        }
        return unitils;
    }

    public static void setInstance(Unitils unitils) {
        Unitils.unitils = unitils;
    }

    public static void initSingletonInstance() {
        unitils = new Unitils();
        unitils.init();
    }

    public void init() {
        ConfigurationLoader configurationLoader = new ConfigurationLoader();
        Properties properties = configurationLoader.loadConfiguration();
        this.init(properties);
    }

    public void init(Properties configuration) {
        this.configuration = configuration;
        this.modulesRepository = this.createModulesRepository(configuration);
        this.testListener = new UnitilsTestListener();
        this.afterInitModules();
    }

    protected void afterInitModules() {
        for (Module module : this.modulesRepository.getModules()) {
            module.afterInit();
        }
    }

    protected void verifyPackaging(Properties configuration) {
        String springCoreClassName = configuration.getProperty("spring.core.someClass.name");
        String unitilsPackagedWithSpring = "org.unitils.includeddeps." + springCoreClassName;
        if (this.isClassAvailable(springCoreClassName) && this.isClassAvailable(unitilsPackagedWithSpring)) {
            throw new IllegalStateException("It appears that you're using the unitils distribution that is packaged with its dependency to spring, while spring is also in your classpath. This is not supported. The spring-packaged distribution can only be used when you're not using spring at all. Please replace unitils-spring-included-version.jar with unitils-version.jar");
        }
    }

    protected boolean isClassAvailable(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public TestListener getTestListener() {
        return this.testListener;
    }

    public ModulesRepository getModulesRepository() {
        return this.modulesRepository;
    }

    public TestContext getTestContext() {
        return this.testContext;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    protected ModulesRepository createModulesRepository(Properties configuration) {
        ModulesLoader modulesLoader = new ModulesLoader();
        List<Module> modules = modulesLoader.loadModules(configuration);
        return new ModulesRepository(modules);
    }

    private class UnitilsTestListener
    extends TestListener {
        private UnitilsTestListener() {
        }

        @Override
        public void beforeTestClass(Class<?> testClass) {
            TestContext testContext = Unitils.this.getTestContext();
            testContext.setTestClass(testClass);
            testContext.setTestObject(null);
            testContext.setTestMethod(null);
            List<Module> modules = Unitils.this.modulesRepository.getModules();
            for (Module module : modules) {
                Unitils.this.modulesRepository.getTestListener(module).beforeTestClass(testClass);
            }
        }

        @Override
        public void afterCreateTestObject(Object testObject) {
            TestContext testContext = Unitils.this.getTestContext();
            testContext.setTestClass(testObject.getClass());
            testContext.setTestObject(testObject);
            testContext.setTestMethod(null);
            List<Module> modules = Unitils.this.modulesRepository.getModules();
            for (Module module : modules) {
                Unitils.this.modulesRepository.getTestListener(module).afterCreateTestObject(testObject);
            }
        }

        @Override
        public void beforeTestSetUp(Object testObject, Method testMethod) {
            TestContext testContext = Unitils.this.getTestContext();
            testContext.setTestClass(testObject.getClass());
            testContext.setTestObject(testObject);
            testContext.setTestMethod(testMethod);
            List<Module> modules = Unitils.this.modulesRepository.getModules();
            for (Module module : modules) {
                Unitils.this.modulesRepository.getTestListener(module).beforeTestSetUp(testObject, testMethod);
            }
        }

        @Override
        public void beforeTestMethod(Object testObject, Method testMethod) {
            TestContext testContext = Unitils.this.getTestContext();
            testContext.setTestClass(testObject.getClass());
            testContext.setTestObject(testObject);
            testContext.setTestMethod(testMethod);
            List<Module> modules = Unitils.this.modulesRepository.getModules();
            for (Module module : modules) {
                Unitils.this.modulesRepository.getTestListener(module).beforeTestMethod(testObject, testMethod);
            }
        }

        @Override
        public void afterTestMethod(Object testObject, Method testMethod, Throwable throwable) {
            TestContext testContext = Unitils.this.getTestContext();
            testContext.setTestClass(testObject.getClass());
            testContext.setTestObject(testObject);
            testContext.setTestMethod(testMethod);
            List<Module> modules = Unitils.this.modulesRepository.getModules();
            for (Module module : modules) {
                Unitils.this.modulesRepository.getTestListener(module).afterTestMethod(testObject, testMethod, throwable);
            }
        }

        @Override
        public void afterTestTearDown(Object testObject, Method testMethod) {
            TestContext testContext = Unitils.this.getTestContext();
            testContext.setTestClass(testObject.getClass());
            testContext.setTestObject(testObject);
            testContext.setTestMethod(null);
            List<Module> modules = Unitils.this.modulesRepository.getModules();
            for (Module module : modules) {
                Unitils.this.modulesRepository.getTestListener(module).afterTestTearDown(testObject, testMethod);
            }
        }

        @Override
        public boolean shouldInvokeTestMethod(Object testObject, Method testMethod) {
            List<Module> modules = Unitils.this.modulesRepository.getModules();
            for (Module module : modules) {
                if (Unitils.this.modulesRepository.getTestListener(module).shouldInvokeTestMethod(testObject, testMethod)) continue;
                return false;
            }
            return true;
        }
    }
}

