/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ClassUtils;
import org.unitils.core.Module;
import org.unitils.core.UnitilsException;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class ModuleUtils {
    public static final String DEFAULT_ENUM_VALUE_NAME = "DEFAULT";

    public static Map<Class<? extends Annotation>, Map<String, String>> getAnnotationPropertyDefaults(Class<? extends Module> moduleClass, Properties configuration, Class<? extends Annotation> ... annotationClasses) {
        HashMap<Class<? extends Annotation>, Map<String, String>> result = new HashMap<Class<? extends Annotation>, Map<String, String>>();
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            Method[] methods;
            for (Method method : methods = annotationClass.getDeclaredMethods()) {
                String defaultValue = ModuleUtils.getAnnotationPropertyDefault(moduleClass, annotationClass, method.getName(), configuration);
                HashMap<String, String> defaultValueMap = (HashMap<String, String>)result.get(annotationClass);
                if (defaultValueMap == null) {
                    defaultValueMap = new HashMap<String, String>();
                    result.put(annotationClass, defaultValueMap);
                }
                defaultValueMap.put(method.getName(), defaultValue);
            }
        }
        return result;
    }

    public static String getAnnotationPropertyDefault(Class<? extends Module> moduleClass, Class<? extends Annotation> annotationClass, String name, Properties configuration) {
        String propertyName = ClassUtils.getShortClassName(moduleClass) + "." + ClassUtils.getShortClassName(annotationClass) + "." + name + ".default";
        if (!PropertyUtils.containsProperty(propertyName, configuration)) {
            return null;
        }
        return PropertyUtils.getString(propertyName, configuration);
    }

    public static <T extends Enum<?>> T getEnumValueReplaceDefault(Class<? extends Annotation> annotation, String annotationPropertyName, T enumValue, Map<Class<? extends Annotation>, Map<String, String>> allDefaultValues) {
        return ModuleUtils.getEnumValueReplaceDefault(annotation, annotationPropertyName, enumValue, allDefaultValues, DEFAULT_ENUM_VALUE_NAME);
    }

    public static <T extends Enum<?>> T getEnumValueReplaceDefault(Class<? extends Annotation> annotation, String annotationPropertyName, T enumValue, Map<Class<? extends Annotation>, Map<String, String>> allDefaultValues, String defaultValueName) {
        String valueAsString = ModuleUtils.getValueAsStringReplaceDefault(annotation, annotationPropertyName, enumValue.name(), allDefaultValues, defaultValueName);
        return (T)ReflectionUtils.getEnumValue(enumValue.getClass(), valueAsString);
    }

    public static Class<?> getClassValueReplaceDefault(Class<? extends Annotation> annotation, String annotationPropertyName, Class<?> value, Map<Class<? extends Annotation>, Map<String, String>> allDefaultValues, Class<?> defaultValueClass) {
        String valueAsString = ModuleUtils.getValueAsStringReplaceDefault(annotation, annotationPropertyName, value.getName(), allDefaultValues, defaultValueClass.getName());
        return ReflectionUtils.getClassWithName(valueAsString);
    }

    private static String getValueAsStringReplaceDefault(Class<? extends Annotation> annotation, String annotationProperty, String valueAsString, Map<Class<? extends Annotation>, Map<String, String>> allDefaultValues, String defaultValueName) {
        String defaultValueAsString;
        if (!defaultValueName.equalsIgnoreCase(valueAsString)) {
            return valueAsString;
        }
        Map<String, String> defaultValues = allDefaultValues.get(annotation);
        if (defaultValues != null && (defaultValueAsString = defaultValues.get(annotationProperty)) != null) {
            return defaultValueAsString;
        }
        throw new UnitilsException("Could not replace default value. No default value found for annotation: " + annotation + ", property " + annotationProperty + ", defaultValues: " + allDefaultValues);
    }
}

