/*
 * Decompiled with CFR 0.152.
 */
package statemachine;

import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import statemachine.model.efsm.mealy.MealyNonDetModel;
import statemachine.model.fsm.fa.NfaModel;
import statemachine.model.fsm.fa.file.Import;
import statemachine.model.fsm.ia.IaNonDetModel;
import statemachine.model.fsm.mealy.file.Export;
import statemachine.model.fsm.moore.MooreNonDetModel;
import statemachine.model.fsm.moore.conversion.Conversion;

public class Main {
    public static void main(String[] args) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"stm").build().defaultHelp(true).description("statemachine tool");
        Subparsers subparsers = parser.addSubparsers().help("sub-command help");
        subparsers.title("subcommands").help(" ").metavar(" ");
        Subparser parserConvert = subparsers.addParser("convert").help("convert lossless the statemachine representation");
        parserConvert.addArgument(new String[]{"conversion_method"}).choices((Object[])new String[]{"fa2moore", "moore2mealy", "mealy2moore", "mealy2ia"}).help("type of conversion");
        parserConvert.addArgument(new String[]{"inputfile"}).type(String.class).help("input file");
        parserConvert.addArgument(new String[]{"outputfile"}).type(String.class).help("output file");
        parserConvert.description("convert lossless the statemachine representation");
        Subparser parserInfo = subparsers.addParser("info").help("displays information about the statemachine:\nnumber of states, number of transitions,  ...");
        parserInfo.addArgument(new String[]{"type"}).choices((Object[])new String[]{"fa", "moore", "mealy", "register"}).help("type of statemachine");
        parserInfo.addArgument(new String[]{"file"}).type(String.class).help("model file");
        parserInfo.description("displays information about the statemachine:\nnumber of states, number of transitions,  ...");
        subparsers.dest("subcommand");
        Namespace parseResult = null;
        try {
            parseResult = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        if (parseResult.getString("subcommand").equals("info")) {
            String type = parseResult.getString("type");
            String filename = parseResult.getString("file");
            switch (type) {
                case "fa": {
                    NfaModel.printSimpleStatistics(filename);
                    break;
                }
                case "moore": {
                    MooreNonDetModel.printSimpleStatistics(filename);
                    break;
                }
                case "mealy": {
                    statemachine.model.fsm.mealy.MealyNonDetModel.printSimpleStatistics(filename);
                    break;
                }
                case "fia": {
                    System.out.println("not yet supported");
                    break;
                }
                case "register": {
                    MealyNonDetModel.printSimpleStatistics(filename);
                    break;
                }
            }
        }
        if (parseResult.getString("subcommand").equals("convert")) {
            String conversion_method = parseResult.getString("conversion_method");
            String inputfile = parseResult.getString("inputfile");
            String outputfile = parseResult.getString("outputfile");
            switch (conversion_method) {
                case "fa2moore": {
                    NfaModel nfaModel = Import.dot2NfaModel(inputfile);
                    MooreNonDetModel mooreModel = statemachine.model.fsm.fa.conversion.Conversion.Fa2MooreNonDetModel(nfaModel);
                    statemachine.model.fsm.moore.file.Export.dot(mooreModel, outputfile);
                    break;
                }
                case "moore2mealy": {
                    MooreNonDetModel mooreModel2 = statemachine.model.fsm.moore.file.Import.dot2MooreModel(inputfile);
                    statemachine.model.fsm.mealy.MealyNonDetModel mealyModel = Conversion.Moore2MealyNonDetModel(mooreModel2);
                    Export.dot(mealyModel, outputfile);
                    break;
                }
                case "mealy2moore": {
                    statemachine.model.fsm.mealy.MealyNonDetModel mealyModel2 = statemachine.model.fsm.mealy.file.Import.dot2MealyModel(inputfile);
                    MooreNonDetModel mooreModel3 = statemachine.model.fsm.mealy.conversion.Conversion.Mealy2MooreNonDetModel(mealyModel2);
                    statemachine.model.fsm.moore.file.Export.dot(mooreModel3, outputfile);
                    break;
                }
                case "mealy2ia": {
                    statemachine.model.fsm.mealy.MealyNonDetModel mealyModel3 = statemachine.model.fsm.mealy.file.Import.dot2MealyModel(inputfile);
                    IaNonDetModel iaModel = statemachine.model.fsm.mealy.conversion.Conversion.Mealy2IaNonDetModel(mealyModel3);
                    statemachine.model.fsm.ia.file.Export.dot(iaModel, outputfile);
                    break;
                }
            }
        }
    }
}

