/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Optional;
import statemachine.interfaces.model.transitions.ModelTransition;

public class Util {
    private static <T extends ModelTransition<?>> void checkForMaximalOneTransition(ImmutableSet<T> transitions) {
        if (transitions.size() > 1) {
            ArrayList<String> strings = new ArrayList<String>();
            for (ModelTransition transition : transitions) {
                strings.add(transition.toString());
            }
            String joined_transitions = String.join((CharSequence)" and ", strings);
            throw new RuntimeException("error in model; none deterministic choice in what should be deterministic; transitions :" + joined_transitions);
        }
    }

    public static <T extends ModelTransition<?>> Optional<T> getOptionalTransition(ImmutableSet<T> transitions) {
        Util.checkForMaximalOneTransition(transitions);
        if (transitions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(transitions.iterator().next());
    }

    public static <T extends ModelTransition<?>> T getTheTransition(ImmutableSet<T> transitions, String location, String actionName) {
        Util.checkForMaximalOneTransition(transitions);
        if (transitions.isEmpty()) {
            throw new RuntimeException("error in model; enabled model doesn't has a transition in state '" + location + "' for action: '" + actionName + "'");
        }
        return (T)((ModelTransition)transitions.iterator().next());
    }
}

