/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.efsm.ia;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.antlr.symtab.VariableSymbol;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.javatuples.Pair;
import statemachine.model.efsm.ia.IaModel;
import statemachine.model.elements.action.ConcreteHiddenAction;
import statemachine.model.elements.action.ConcreteInputAction;
import statemachine.model.elements.action.ConcreteOutputAction;
import statemachine.model.elements.action.DataHiddenActionType;
import statemachine.model.elements.action.DataInputActionType;
import statemachine.model.elements.action.DataOutputActionType;
import statemachine.model.elements.action.SymbolicHiddenAction;
import statemachine.model.elements.action.SymbolicInputAction;
import statemachine.model.elements.action.SymbolicOutputAction;
import statemachine.model.elements.action.Value;
import statemachine.model.elements.location.DataLocationState;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.transition.BaseSymbolicTransition;
import statemachine.model.elements.transition.SymbolicHiddenTransition;
import statemachine.model.elements.transition.SymbolicInputTransition;
import statemachine.model.elements.transition.SymbolicOutputTransition;
import statemachine.model.elements.transition.Transition;

@NonNullByDefault
public abstract class IaBaseModel
implements IaModel {
    protected final ImmutableSet<DataInputActionType> inputalphabet;
    protected final ImmutableSet<DataOutputActionType> outputalphabet;
    protected final ImmutableSet<DataHiddenActionType> hiddenalphabet;
    private final DataLocationState startState;
    protected final ImmutableMap<VariableSymbol, Value> constants;
    private final ImmutableSet<Location> locations;
    private final ImmutableSet<SymbolicInputTransition> inputTransitions;
    private final ImmutableSet<SymbolicOutputTransition> outputTransitions;
    protected final ImmutableSet<SymbolicHiddenTransition> hiddenTransitions;
    protected final ImmutableSetMultimap<Location, SymbolicInputTransition> loc2inputtrans;
    protected final ImmutableSetMultimap<Location, SymbolicOutputTransition> loc2outputtrans;
    protected final ImmutableSetMultimap<Location, SymbolicHiddenTransition> loc2hiddentrans;

    protected IaBaseModel(ImmutableBuilder builder) {
        this.inputalphabet = builder.inputalphabet;
        this.outputalphabet = builder.outputalphabet;
        this.hiddenalphabet = builder.hiddenalphabet;
        this.startState = builder.startState;
        this.constants = builder.constants;
        this.locations = builder.locations;
        this.inputTransitions = builder.inputTransitions;
        this.loc2inputtrans = builder.loc2inputtrans;
        this.outputTransitions = builder.outputTransitions;
        this.loc2outputtrans = builder.loc2outputtrans;
        this.hiddenTransitions = builder.hiddenTransitions;
        this.loc2hiddentrans = builder.loc2hiddentrans;
    }

    @Override
    public ImmutableMap<VariableSymbol, Value> getConstants() {
        return this.constants;
    }

    @Override
    public @NonNull Location getStartLocation() {
        return this.startState.getLocation();
    }

    @Override
    public @NonNull DataLocationState getStartState() {
        return this.startState;
    }

    @Override
    public ImmutableSet<Location> getLocations() {
        return this.locations;
    }

    @Override
    public ImmutableSet<Transition<Location>> getModelTransitions() {
        HashSet<BaseSymbolicTransition> set = new HashSet<BaseSymbolicTransition>();
        set.addAll((Collection<BaseSymbolicTransition>)this.inputTransitions);
        set.addAll((Collection<BaseSymbolicTransition>)this.outputTransitions);
        set.addAll((Collection<BaseSymbolicTransition>)this.hiddenTransitions);
        return ImmutableSet.copyOf(set);
    }

    @Override
    public ImmutableSet<Transition<Location>> getModelTransitions(Location location) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        transitionsBuilder.addAll((Iterable)this.loc2inputtrans.get((Object)location));
        transitionsBuilder.addAll((Iterable)this.loc2outputtrans.get((Object)location));
        transitionsBuilder.addAll((Iterable)this.loc2hiddentrans.get((Object)location));
        return transitionsBuilder.build();
    }

    @Override
    public ImmutableSet<DataInputActionType> getInputAlphabet() {
        return this.inputalphabet;
    }

    @Override
    public ImmutableSet<DataOutputActionType> getOutputAlphabet() {
        return this.outputalphabet;
    }

    @Override
    public ImmutableSet<DataHiddenActionType> getHiddenAlphabet() {
        return this.hiddenalphabet;
    }

    @Override
    public ImmutableSet<SymbolicInputTransition> getModelInputTransitions() {
        return this.inputTransitions;
    }

    @Override
    public ImmutableSet<SymbolicInputTransition> getModelInputTransitions(Location location) {
        return this.loc2inputtrans.get((Object)location);
    }

    @Override
    public ImmutableSet<SymbolicOutputTransition> getModelOutputTransitions() {
        return this.outputTransitions;
    }

    @Override
    public ImmutableSet<SymbolicOutputTransition> getModelOutputTransitions(Location location) {
        return this.loc2outputtrans.get((Object)location);
    }

    @Override
    public ImmutableSet<SymbolicHiddenTransition> getModelHiddenTransitions() {
        return this.hiddenTransitions;
    }

    @Override
    public ImmutableSet<SymbolicHiddenTransition> getModelHiddenTransitions(Location location) {
        return this.loc2hiddentrans.get((Object)location);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull SymbolicInputTransition> getModelInputTransitions(Location location, DataInputActionType action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2inputtrans.get((Object)location);
        for (SymbolicInputTransition transition : transitions) {
            if (!((DataInputActionType)transition.getInput().getType()).equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull SymbolicOutputTransition> getModelOutputTransitions(Location location, DataOutputActionType action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2outputtrans.get((Object)location);
        for (SymbolicOutputTransition transition : transitions) {
            if (!((DataOutputActionType)transition.getOutput().getType()).equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull SymbolicHiddenTransition> getModelHiddenTransitions(Location location, DataHiddenActionType action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2hiddentrans.get((Object)location);
        for (SymbolicHiddenTransition transition : transitions) {
            if (!((DataHiddenActionType)transition.getHiddenAction().getType()).equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    @Override
    public boolean isEnabledInputTransition(DataLocationState state, ConcreteInputAction input, SymbolicInputTransition inputTransition) {
        return false;
    }

    @Override
    public boolean isEnabledOutputTransition(DataLocationState state, SymbolicOutputTransition outputTransition) {
        return false;
    }

    @Override
    public boolean isEnabledHiddenTransition(DataLocationState state, ConcreteHiddenAction hiddenAction, SymbolicHiddenTransition hiddenTransition) {
        return false;
    }

    @Override
    public DataLocationState evaluateInputTransition(DataLocationState state, ConcreteInputAction input, SymbolicInputTransition inputTransition) {
        return null;
    }

    @Override
    public Pair<DataLocationState, ConcreteOutputAction> evaluateOutputTransition(DataLocationState state, SymbolicOutputTransition outputTransition) {
        return null;
    }

    @Override
    public DataLocationState evaluateHiddenTransition(DataLocationState state, ConcreteHiddenAction hiddenAction, SymbolicHiddenTransition hiddenTransition) {
        return null;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("start state: " + this.startState);
        joiner.add("constants: " + this.constants);
        joiner.add("inputAlphabet: " + this.inputalphabet);
        joiner.add("outputAlphabet: " + this.outputalphabet);
        joiner.add("hiddenAlphabet: " + this.hiddenalphabet);
        joiner.add("locations:");
        for (Location location : this.getLocations()) {
            joiner.add(location.toString());
        }
        joiner.add("transitions:");
        for (BaseSymbolicTransition transition : this.getModelInputTransitions()) {
            joiner.add(((SymbolicInputTransition)transition).toString());
        }
        for (BaseSymbolicTransition transition : this.getModelOutputTransitions()) {
            joiner.add(((SymbolicOutputTransition)transition).toString());
        }
        for (BaseSymbolicTransition transition : this.getModelHiddenTransitions()) {
            joiner.add(((SymbolicHiddenTransition)transition).toString());
        }
        joiner.add("");
        return joiner.toString();
    }

    public static abstract class ImmutableBuilder {
        protected ImmutableSet<DataInputActionType> inputalphabet;
        protected ImmutableSet<DataOutputActionType> outputalphabet;
        protected ImmutableSet<DataHiddenActionType> hiddenalphabet;
        protected DataLocationState startState;
        private ImmutableMap<VariableSymbol, Value> constants;
        protected ImmutableSet<Location> locations;
        protected ImmutableSet<SymbolicInputTransition> inputTransitions;
        protected ImmutableSet<SymbolicOutputTransition> outputTransitions;
        protected ImmutableSet<SymbolicHiddenTransition> hiddenTransitions;
        protected ImmutableSetMultimap<Location, SymbolicInputTransition> loc2inputtrans;
        protected ImmutableSetMultimap<Location, SymbolicOutputTransition> loc2outputtrans;
        protected ImmutableSetMultimap<Location, SymbolicHiddenTransition> loc2hiddentrans;
        protected ImmutableSet.Builder<Location> locationsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<SymbolicInputTransition> inputTransitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<SymbolicOutputTransition> outputTransitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<SymbolicHiddenTransition> hiddenTransitionsBuilder = ImmutableSet.builder();
        protected ImmutableSetMultimap.Builder<Location, SymbolicInputTransition> loc2inputTransBuilder = ImmutableSetMultimap.builder();
        protected ImmutableSetMultimap.Builder<Location, SymbolicOutputTransition> loc2outputTransBuilder = ImmutableSetMultimap.builder();
        protected ImmutableSetMultimap.Builder<Location, SymbolicHiddenTransition> loc2hiddenTransBuilder = ImmutableSetMultimap.builder();
        private HashMap<String, DataInputActionType> name2input = new HashMap();
        private HashMap<String, DataOutputActionType> name2output = new HashMap();
        private HashMap<String, DataHiddenActionType> name2hidden = new HashMap();

        public ImmutableBuilder addInputTransition(Location src, Location dst, SymbolicInputAction input, String guard, String update) {
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicInputTransition transition = new SymbolicInputTransition(src, dst, input, guard, update);
            this.inputTransitionsBuilder.add((Object)transition);
            this.loc2inputTransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addInputTransition(Location src, Location dst, SymbolicInputAction input, String guard) {
            this.addInputTransition(src, dst, input, guard, null);
            return this;
        }

        public ImmutableBuilder addInputTransition(Location src, Location dst, SymbolicInputAction input) {
            this.addInputTransition(src, dst, input, null, null);
            return this;
        }

        public ImmutableBuilder addInputTransition(Location src, Location dst, String inputStr, String guard, String update) {
            SymbolicInputAction input = this.parseInput(inputStr);
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicInputTransition transition = new SymbolicInputTransition(src, dst, input, guard, update);
            this.inputTransitionsBuilder.add((Object)transition);
            this.loc2inputTransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addInputTransition(Location src, Location dst, String input, String guard) {
            this.addInputTransition(src, dst, input, guard, "");
            return this;
        }

        public ImmutableBuilder addInputTransition(Location src, Location dst, String input) {
            this.addInputTransition(src, dst, input, "", "");
            return this;
        }

        public ImmutableBuilder addOutputTransition(Location src, Location dst, SymbolicOutputAction output, String guard, String update) {
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicOutputTransition transition = new SymbolicOutputTransition(src, dst, output, guard, update);
            this.outputTransitionsBuilder.add((Object)transition);
            this.loc2outputTransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addOutputTransition(Location src, Location dst, SymbolicOutputAction output, String guard) {
            this.addOutputTransition(src, dst, output, guard, null);
            return this;
        }

        public ImmutableBuilder addOutputTransition(Location src, Location dst, SymbolicOutputAction output) {
            this.addOutputTransition(src, dst, output, null, null);
            return this;
        }

        public ImmutableBuilder addOutputTransition(Location src, Location dst, String outputStr, String guard, String update) {
            SymbolicOutputAction output = this.parseOutput(outputStr);
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicOutputTransition transition = new SymbolicOutputTransition(src, dst, output, guard, update);
            this.outputTransitionsBuilder.add((Object)transition);
            this.loc2outputTransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addOutputTransition(Location src, Location dst, String output, String guard) {
            this.addOutputTransition(src, dst, output, guard, "");
            return this;
        }

        public ImmutableBuilder addOutputTransition(Location src, Location dst, String output) {
            this.addOutputTransition(src, dst, output, "", "");
            return this;
        }

        public ImmutableBuilder addHiddenTransition(Location src, Location dst, SymbolicHiddenAction hidden, String guard, String update) {
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicHiddenTransition transition = new SymbolicHiddenTransition(src, dst, hidden, guard, update);
            this.hiddenTransitionsBuilder.add((Object)transition);
            this.loc2hiddenTransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addHiddenTransition(Location src, Location dst, SymbolicHiddenAction hidden, String guard) {
            this.addHiddenTransition(src, dst, hidden, guard, null);
            return this;
        }

        public ImmutableBuilder addHiddenTransition(Location src, Location dst, SymbolicHiddenAction hidden) {
            this.addHiddenTransition(src, dst, hidden, null, null);
            return this;
        }

        public ImmutableBuilder addHiddenTransition(Location src, Location dst, String hiddenStr, String guard, String update) {
            SymbolicHiddenAction hidden = this.parseHidden(hiddenStr);
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicHiddenTransition transition = new SymbolicHiddenTransition(src, dst, hidden, guard, update);
            this.hiddenTransitionsBuilder.add((Object)transition);
            this.loc2hiddenTransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addHiddenTransition(Location src, Location dst, String hidden, String guard) {
            this.addHiddenTransition(src, dst, hidden, guard, "");
            return this;
        }

        public ImmutableBuilder addHiddenTransition(Location src, Location dst, String hidden) {
            this.addHiddenTransition(src, dst, hidden, "", "");
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, String action, String guard, String update) {
            BaseSymbolicTransition transition;
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            String name = this.parseActionName(action);
            if (this.name2input.containsKey(name)) {
                SymbolicInputAction input = this.parseInput(action);
                transition = new SymbolicInputTransition(src, dst, input, guard, update);
                this.inputTransitionsBuilder.add((Object)transition);
                this.loc2inputTransBuilder.put((Object)src, (Object)transition);
            }
            if (this.name2output.containsKey(name)) {
                SymbolicOutputAction output = this.parseOutput(action);
                transition = new SymbolicOutputTransition(src, dst, output, guard, update);
                this.outputTransitionsBuilder.add((Object)transition);
                this.loc2outputTransBuilder.put((Object)src, (Object)transition);
            }
            if (this.name2hidden.containsKey(name)) {
                SymbolicHiddenAction hidden = this.parseHidden(action);
                transition = new SymbolicHiddenTransition(src, dst, hidden, guard, update);
                this.hiddenTransitionsBuilder.add((Object)transition);
                this.loc2hiddenTransBuilder.put((Object)src, (Object)transition);
            }
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, String action, String guard) {
            this.addInputTransition(src, dst, action, guard, "");
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, String action) {
            this.addInputTransition(src, dst, action, "", "");
            return this;
        }

        public ImmutableBuilder setInputAlphabet(List<DataInputActionType> actionTypes) {
            this.inputalphabet = ImmutableSet.copyOf(actionTypes);
            for (DataInputActionType inputType : actionTypes) {
                this.name2input.put(inputType.getName(), inputType);
            }
            return this;
        }

        public ImmutableBuilder setInputAlphabet(DataInputActionType ... actionTypes) {
            this.setInputAlphabet(Arrays.asList(actionTypes));
            return this;
        }

        public ImmutableBuilder setOutputAlphabet(List<DataOutputActionType> actionTypes) {
            this.outputalphabet = ImmutableSet.copyOf(actionTypes);
            for (DataOutputActionType outputType : actionTypes) {
                this.name2output.put(outputType.getName(), outputType);
            }
            return this;
        }

        public ImmutableBuilder setOutputAlphabet(DataOutputActionType ... actionTypes) {
            this.setOutputAlphabet(Arrays.asList(actionTypes));
            return this;
        }

        public ImmutableBuilder setHiddenAlphabet(List<DataHiddenActionType> actionTypes) {
            this.hiddenalphabet = ImmutableSet.copyOf(actionTypes);
            for (DataHiddenActionType outputType : actionTypes) {
                this.name2hidden.put(outputType.getName(), outputType);
            }
            return this;
        }

        public ImmutableBuilder setHiddenAlphabet(DataHiddenActionType ... actionTypes) {
            this.setHiddenAlphabet(Arrays.asList(actionTypes));
            return this;
        }

        private Pair<String, List<String>> parseAction(String actionString) {
            int startIndex = actionString.indexOf("(");
            int endIndex = actionString.indexOf(")");
            String name = actionString.substring(0, startIndex).trim();
            String[] params = actionString.substring(startIndex + 1, endIndex).trim().split("\\s*,\\s*");
            return new Pair((Object)name, Arrays.asList(params));
        }

        private String parseActionName(String actionString) {
            int startIndex = actionString.indexOf("(");
            String name = actionString.substring(0, startIndex).trim();
            return name;
        }

        private SymbolicInputAction parseInput(String inputStr) {
            Pair<String, List<String>> name_params = this.parseAction(inputStr);
            DataInputActionType actionType = this.name2input.get(name_params.getValue0());
            SymbolicInputAction input = new SymbolicInputAction(actionType, (List)name_params.getValue1());
            return input;
        }

        private SymbolicOutputAction parseOutput(String inputStr) {
            Pair<String, List<String>> name_params = this.parseAction(inputStr);
            DataOutputActionType actionType = this.name2output.get(name_params.getValue0());
            SymbolicOutputAction input = new SymbolicOutputAction(actionType, (List)name_params.getValue1());
            return input;
        }

        private SymbolicHiddenAction parseHidden(String hiddenStr) {
            Pair<String, List<String>> name_params = this.parseAction(hiddenStr);
            DataHiddenActionType actionType = this.name2hidden.get(name_params.getValue0());
            SymbolicHiddenAction hidden = new SymbolicHiddenAction(actionType, (List)name_params.getValue1());
            return hidden;
        }

        public ImmutableBuilder setStartState(Location startLocation) {
            this.startState = new DataLocationState(startLocation);
            return this;
        }

        public ImmutableBuilder setStartState(DataLocationState startState) {
            this.startState = startState;
            return this;
        }

        public ImmutableBuilder setStartState(Location startLocation, HashMap<VariableSymbol, Value> statevars) {
            this.startState = new DataLocationState(startLocation, statevars);
            return this;
        }

        public ImmutableBuilder setConstants(Map<VariableSymbol, Value> constants) {
            this.constants = ImmutableMap.copyOf(constants);
            return this;
        }

        public ImmutableBuilder addFromIaModel(IaModel model) {
            for (BaseSymbolicTransition trans : model.getModelInputTransitions()) {
                this.addInputTransition((Location)trans.getSource(), (Location)trans.getDestination(), ((SymbolicInputTransition)trans).getInput());
            }
            for (BaseSymbolicTransition trans : model.getModelOutputTransitions()) {
                this.addOutputTransition((Location)trans.getSource(), (Location)trans.getDestination(), ((SymbolicOutputTransition)trans).getOutput());
            }
            for (BaseSymbolicTransition trans : model.getModelHiddenTransitions()) {
                this.addHiddenTransition((Location)trans.getSource(), (Location)trans.getDestination(), ((SymbolicHiddenTransition)trans).getHiddenAction());
            }
            this.setStartState((DataLocationState)model.getStartState());
            this.setConstants((Map<VariableSymbol, Value>)model.getConstants());
            return this;
        }

        protected void baseBuild() {
            this.locations = this.locationsBuilder.build();
            this.inputTransitions = this.inputTransitionsBuilder.build();
            this.loc2inputtrans = this.loc2inputTransBuilder.build();
            this.outputTransitions = this.outputTransitionsBuilder.build();
            this.loc2outputtrans = this.loc2outputTransBuilder.build();
            this.hiddenTransitions = this.hiddenTransitionsBuilder.build();
            this.loc2hiddentrans = this.loc2hiddenTransBuilder.build();
        }
    }
}

