/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.efsm.ia.conversion;

import org.antlr.symtab.PrimitiveType;
import org.antlr.symtab.Type;
import org.javatuples.Quartet;
import statemachine.model.efsm.ia.IaModel;
import statemachine.model.efsm.ia.IaNonDetModel;
import statemachine.model.efsm.ia.conversion.TransitionLabelFormatter;
import statemachine.model.efsm.ia.conversion.TransitionLabelParser;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.action.DataInputActionType;
import statemachine.model.elements.action.DataOutputActionType;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.elements.transition.BaseSymbolicTransition;
import statemachine.model.elements.transition.SymbolicHiddenTransition;
import statemachine.model.elements.transition.SymbolicInputTransition;
import statemachine.model.elements.transition.SymbolicOutputTransition;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class LtsZip {
    public static TransitionLabelFormatter defaultTransitionLabelFormatter = (type, action, guard, update) -> {
        String guardStr = "";
        String updateStr = "";
        String sep = "";
        if (update.isPresent()) {
            updateStr = "{" + (String)update.get() + "}";
        }
        if (guard.isPresent()) {
            guardStr = "[" + (String)guard.get() + "]";
        }
        if (type.equals("input")) {
            if (update.isPresent()) {
                sep = "/";
            }
            return "?" + action + guardStr + sep + updateStr;
        }
        if (type.equals("output")) {
            if (guard.isPresent()) {
                sep = "/";
            }
            return guardStr + sep + updateStr + "!" + action;
        }
        if (type.equals("hidden")) {
            if (update.isPresent()) {
                sep = "/";
            }
            return "_" + action + guardStr + sep + updateStr;
        }
        return "error inTransitionLabelFormatter";
    };
    public static TransitionLabelParser defaultTransitionLabelParser = new TransitionLabelParser(){

        @Override
        public Quartet<String, String, String, String> apply(String label) {
            String action;
            int endIndex;
            int startIndex;
            String type = "error";
            String update = "";
            String guard = "";
            String action_guard = "";
            String update_output = "";
            if (label.contains("/")) {
                String[] parts = label.split("/");
                action_guard = parts[0];
                if (parts.length > 1) {
                    update_output = parts[1];
                }
            } else {
                update_output = label;
            }
            if (action_guard.contains("[")) {
                startIndex = action_guard.indexOf("[");
                endIndex = action_guard.indexOf("]");
                guard = action_guard.substring(startIndex + 1, endIndex).trim();
                action = action_guard.substring(0, startIndex).trim();
            } else {
                action = action_guard.trim();
            }
            if (action.startsWith("_")) {
                type = "hidden";
            } else if (action.startsWith("?")) {
                type = "input";
            } else {
                endIndex = update_output.indexOf("}");
                action = update_output.substring(endIndex + 1).trim();
                if (action.startsWith("!")) {
                    type = "output";
                }
            }
            action = action.substring(1);
            if (update_output.contains("{")) {
                startIndex = update_output.indexOf("{");
                endIndex = update_output.indexOf("}");
                update = update_output.substring(startIndex + 1, endIndex).trim();
            }
            return new Quartet((Object)type, (Object)action, (Object)guard, (Object)update);
        }
    };

    public static LtsNonDetModel zipIa2Lts(IaModel model, TransitionLabelFormatter transitionFormatter) {
        Action action;
        String label;
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (BaseSymbolicTransition trans : model.getModelInputTransitions()) {
            label = transitionFormatter.apply("input", ((SymbolicInputTransition)trans).getInput().asString(), trans.getGuard(), trans.getUpdate());
            action = new Action(label);
            builder.addTransition(new LocationState(((Location)trans.getSource()).getName()), new LocationState(((Location)trans.getDestination()).getName()), action);
        }
        for (BaseSymbolicTransition trans : model.getModelOutputTransitions()) {
            label = transitionFormatter.apply("output", ((SymbolicOutputTransition)trans).getOutput().asString(), trans.getGuard(), trans.getUpdate());
            action = new Action(label);
            builder.addTransition(new LocationState(((Location)trans.getSource()).getName()), new LocationState(((Location)trans.getDestination()).getName()), action);
        }
        for (BaseSymbolicTransition trans : model.getModelHiddenTransitions()) {
            label = transitionFormatter.apply("hidden", ((SymbolicHiddenTransition)trans).getHiddenAction().asString(), trans.getGuard(), trans.getUpdate());
            action = new Action(label);
            builder.addTransition(new LocationState(((Location)trans.getSource()).getName()), new LocationState(((Location)trans.getDestination()).getName()), action);
        }
        builder.setStartLocation(new LocationState(((Location)model.getStartLocation()).getName()));
        return builder.build();
    }

    public static LtsNonDetModel zipIa2Lts(IaModel model) {
        return LtsZip.zipIa2Lts(model, defaultTransitionLabelFormatter);
    }

    public static IaNonDetModel unzipLts2Ia(LtsModel model, TransitionLabelParser labelParser) {
        IaNonDetModel.ImmutableBuilder builder = new IaNonDetModel.ImmutableBuilder();
        PrimitiveType integer = new PrimitiveType("INT");
        DataInputActionType A = new DataInputActionType("a", new Type[]{integer, integer});
        DataInputActionType B = new DataInputActionType("b", new Type[]{integer});
        DataOutputActionType OUT = new DataOutputActionType("OUT", new Type[]{integer, integer});
        DataOutputActionType OK = new DataOutputActionType("OK", new Type[]{integer});
        builder.setInputAlphabet(A, B);
        builder.setOutputAlphabet(OUT, OK);
        for (ActionTransition trans : model.getModelTransitions()) {
            String label = trans.getAction().getName();
            Quartet<String, String, String, String> type_action_guard_update = labelParser.apply(label);
            String type = (String)type_action_guard_update.getValue0();
            String action = (String)type_action_guard_update.getValue1();
            String guard = (String)type_action_guard_update.getValue2();
            String update = (String)type_action_guard_update.getValue3();
            if (type.equals("input")) {
                builder.addInputTransition(new Location(((LocationState)trans.getSource()).getName()), new Location(((LocationState)trans.getDestination()).getName()), action, guard, update);
                continue;
            }
            if (type.equals("output")) {
                builder.addOutputTransition(new Location(((LocationState)trans.getSource()).getName()), new Location(((LocationState)trans.getDestination()).getName()), action, guard, update);
                continue;
            }
            if (!type.equals("hidden")) continue;
            builder.addHiddenTransition(new Location(((LocationState)trans.getSource()).getName()), new Location(((LocationState)trans.getDestination()).getName()), action, guard, update);
        }
        builder.setStartState(new Location(((LocationState)model.getStartLocation()).getName()));
        return builder.build();
    }

    public static IaNonDetModel unzipLts2Ia(LtsModel model) {
        return LtsZip.unzipLts2Ia(model, defaultTransitionLabelParser);
    }
}

