/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.efsm.ia.file;

import exceptionslib.FileIOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXB;
import org.antlr.symtab.PrimitiveType;
import org.antlr.symtab.Type;
import org.antlr.symtab.VariableSymbol;
import statemachine.model.efsm.ia.IaNonDetModel;
import statemachine.model.efsm.ia.conversion.LtsZip;
import statemachine.model.efsm.ia.file.RegisterAutomaton;
import statemachine.model.elements.action.DataInputActionType;
import statemachine.model.elements.action.DataOutputActionType;
import statemachine.model.elements.action.Value;
import statemachine.model.elements.location.DataLocationState;
import statemachine.model.elements.location.Location;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class Import {
    public static IaNonDetModel dot2IaModel(String filename) {
        LtsNonDetModel lts = statemachine.model.fsm.lts.file.Import.dot2LtsModel(filename);
        return LtsZip.unzipLts2Ia(lts);
    }

    public static IaNonDetModel aldebaran2IaModel(String filename) {
        LtsNonDetModel lts = statemachine.model.fsm.lts.file.Import.aldebaran2LtsModel(filename);
        return LtsZip.unzipLts2Ia(lts);
    }

    public static IaNonDetModel gml2IaModel(String filename) {
        LtsNonDetModel lts = statemachine.model.fsm.lts.file.Import.gml2LtsModel(filename);
        return LtsZip.unzipLts2Ia(lts);
    }

    /*
     * WARNING - void declaration
     */
    public static IaNonDetModel register2IaModel(String filename) {
        void var9_24;
        RegisterAutomaton register;
        PrimitiveType integer = new PrimitiveType("INT");
        HashMap<String, PrimitiveType> name2type = new HashMap<String, PrimitiveType>();
        name2type.put("int", integer);
        name2type.put("integer", integer);
        try {
            Path path = Paths.get(filename, new String[0]);
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            register = (RegisterAutomaton)JAXB.unmarshal((InputStream)is, RegisterAutomaton.class);
        }
        catch (Exception e) {
            throw new FileIOException(e).addDecoration("filename", (Object)filename);
        }
        IaNonDetModel.ImmutableBuilder builder = new IaNonDetModel.ImmutableBuilder();
        LinkedList<DataInputActionType> inputTypes = new LinkedList<DataInputActionType>();
        for (RegisterAutomaton.Alphabet.Inputs.Symbol symbol : register.getAlphabet().getInputs().getSymbol()) {
            String string = symbol.getName();
            LinkedList<Type> linkedList = new LinkedList<Type>();
            for (RegisterAutomaton.Alphabet.Inputs.Symbol.Param param : symbol.getParam()) {
                linkedList.add((Type)name2type.get(param.getType()));
            }
            inputTypes.add(new DataInputActionType(string, linkedList));
        }
        builder.setInputAlphabet(inputTypes);
        LinkedList<DataOutputActionType> outputTypes = new LinkedList<DataOutputActionType>();
        for (RegisterAutomaton.Alphabet.Outputs.Symbol symbol : register.getAlphabet().getOutputs().getSymbol()) {
            String string = symbol.getName();
            LinkedList<Type> linkedList = new LinkedList<Type>();
            for (RegisterAutomaton.Alphabet.Outputs.Symbol.Param param : symbol.getParam()) {
                linkedList.add((Type)name2type.get(param.getType()));
            }
            outputTypes.add(new DataOutputActionType(string, linkedList));
        }
        builder.setOutputAlphabet(outputTypes);
        HashMap<VariableSymbol, Value> hashMap = new HashMap<VariableSymbol, Value>();
        for (RegisterAutomaton.Constants.Constant constant : register.getConstants().getConstant()) {
            hashMap.put(new VariableSymbol(constant.getName()), new Value((Type)name2type.get(constant.getType()), constant.getValue()));
        }
        builder.setConstants(hashMap);
        HashMap<VariableSymbol, Value> hashMap2 = new HashMap<VariableSymbol, Value>();
        for (RegisterAutomaton.Globals.Variable variable : register.getGlobals().getVariable()) {
            hashMap2.put(new VariableSymbol(variable.getName()), new Value((Type)name2type.get(variable.getType()), variable.getValue()));
        }
        Object var9_22 = null;
        for (RegisterAutomaton.Locations.Location location : register.getLocations().getLocation()) {
            String initial = location.getInitial();
            if (initial == null || !initial.equals("true")) continue;
            Location location2 = new Location(location.getName());
            break;
        }
        if (var9_24 == null) {
            System.err.println("start state missing");
        }
        DataLocationState dataLocationState = new DataLocationState((Location)var9_24, hashMap2);
        builder.setStartState(dataLocationState);
        for (RegisterAutomaton.Transitions.Transition transition : register.getTransitions().getTransition()) {
            String from = transition.getFrom();
            String to = transition.getTo();
            String guard = transition.getGuard();
            String comma_separated_params = transition.getParams();
            if (comma_separated_params == null) {
                comma_separated_params = "";
            }
            LinkedList<String> updates = new LinkedList<String>();
            if (transition.getAssignments() != null) {
                for (RegisterAutomaton.Transitions.Transition.Assignments.Assign assign : transition.getAssignments().getAssign()) {
                    updates.add(assign.getTo() + "=" + assign.getValue() + ";");
                }
            }
            String update = String.join((CharSequence)"", updates);
            String actionname = transition.getSymbol();
            builder.addTransition(new Location(from), new Location(to), actionname + "(" + comma_separated_params + ")", guard, update);
        }
        return builder.build();
    }
}

