/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.efsm.mealy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.antlr.symtab.VariableSymbol;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.javatuples.Pair;
import statemachine.model.efsm.mealy.MealyModel;
import statemachine.model.elements.action.ConcreteInputAction;
import statemachine.model.elements.action.ConcreteOutputAction;
import statemachine.model.elements.action.DataInputActionType;
import statemachine.model.elements.action.DataOutputActionType;
import statemachine.model.elements.action.SymbolicInputAction;
import statemachine.model.elements.action.SymbolicOutputAction;
import statemachine.model.elements.action.Value;
import statemachine.model.elements.location.DataLocationState;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.transition.SymbolicMealyTransition;

@NonNullByDefault
public abstract class MealyBaseModel
implements MealyModel {
    protected final ImmutableSet<DataInputActionType> inputalphabet;
    protected final ImmutableSet<DataOutputActionType> outputalphabet;
    private final DataLocationState startState;
    protected final ImmutableMap<VariableSymbol, Value> constants;
    private final ImmutableSet<Location> locations;
    private final ImmutableSet<SymbolicMealyTransition> transitions;
    protected final ImmutableSetMultimap<Location, SymbolicMealyTransition> loc2trans;

    protected MealyBaseModel(ImmutableBuilder builder) {
        this.inputalphabet = builder.inputalphabet;
        this.outputalphabet = builder.outputalphabet;
        this.startState = builder.startState;
        this.constants = builder.constants;
        this.locations = builder.locations;
        this.transitions = builder.transitions;
        this.loc2trans = builder.loc2trans;
    }

    @Override
    public ImmutableMap<VariableSymbol, Value> getConstants() {
        return this.constants;
    }

    @Override
    public @NonNull Location getStartLocation() {
        return this.startState.getLocation();
    }

    @Override
    public @NonNull DataLocationState getStartState() {
        return this.startState;
    }

    @Override
    public ImmutableSet<Location> getLocations() {
        return this.locations;
    }

    @Override
    public ImmutableSet<SymbolicMealyTransition> getModelTransitions() {
        return this.transitions;
    }

    @Override
    public ImmutableSet<SymbolicMealyTransition> getModelTransitions(Location location) {
        return this.loc2trans.get((Object)location);
    }

    @Override
    public ImmutableSet<DataInputActionType> getInputAlphabet() {
        return this.inputalphabet;
    }

    @Override
    public ImmutableSet<DataOutputActionType> getOutputAlphabet() {
        return this.outputalphabet;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull SymbolicMealyTransition> getModelTransitions(Location location, DataInputActionType action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2trans.get((Object)location);
        for (SymbolicMealyTransition transition : transitions) {
            if (!((DataInputActionType)transition.getInput().getType()).equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    @Override
    public boolean isEnabledTransition(DataLocationState state, ConcreteInputAction input, SymbolicMealyTransition transition) {
        return false;
    }

    @Override
    public Pair<DataLocationState, ConcreteOutputAction> evaluateTransition(DataLocationState state, ConcreteInputAction input, SymbolicMealyTransition transition) {
        return null;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("start state: " + this.startState);
        joiner.add("constants: " + this.constants);
        joiner.add("inputAlphabet: " + this.inputalphabet);
        joiner.add("outputAlphabet: " + this.outputalphabet);
        joiner.add("locations:");
        for (Location location : this.getLocations()) {
            joiner.add(location.toString());
        }
        joiner.add("transitions:");
        for (SymbolicMealyTransition transition : this.getModelTransitions()) {
            joiner.add(transition.toString());
        }
        joiner.add("");
        return joiner.toString();
    }

    public static abstract class ImmutableBuilder {
        protected ImmutableSet<DataInputActionType> inputalphabet;
        protected ImmutableSet<DataOutputActionType> outputalphabet;
        protected DataLocationState startState;
        private ImmutableMap<VariableSymbol, Value> constants;
        protected ImmutableSet<Location> locations;
        protected ImmutableSet<SymbolicMealyTransition> transitions;
        protected ImmutableSetMultimap<Location, SymbolicMealyTransition> loc2trans;
        protected ImmutableSet.Builder<Location> locationsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<SymbolicMealyTransition> transitionsBuilder = ImmutableSet.builder();
        protected ImmutableSetMultimap.Builder<Location, SymbolicMealyTransition> loc2transBuilder = ImmutableSetMultimap.builder();
        private HashMap<String, DataInputActionType> name2input;
        private HashMap<String, DataOutputActionType> name2output;

        public ImmutableBuilder addTransition(Location src, Location dst, SymbolicInputAction input, SymbolicOutputAction output, String guard, String update) {
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicMealyTransition transition = new SymbolicMealyTransition(src, dst, input, output, guard, update);
            this.transitionsBuilder.add((Object)transition);
            this.loc2transBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, SymbolicInputAction input, SymbolicOutputAction output) {
            this.addTransition(src, dst, input, output, null, null);
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, SymbolicInputAction input, SymbolicOutputAction output, String guard) {
            this.addTransition(src, dst, input, output, guard, null);
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, String inputStr, SymbolicOutputAction output, String guard, String update) {
            SymbolicInputAction input = this.parseInput(inputStr);
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicMealyTransition transition = new SymbolicMealyTransition(src, dst, input, output, guard, update);
            this.transitionsBuilder.add((Object)transition);
            this.loc2transBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, String inputStr, String outputStr, String guard, String update) {
            SymbolicInputAction input = this.parseInput(inputStr);
            SymbolicOutputAction output = this.parseOutput(outputStr);
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            SymbolicMealyTransition transition = new SymbolicMealyTransition(src, dst, input, output, guard, update);
            this.transitionsBuilder.add((Object)transition);
            this.loc2transBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder setInputAlphabet(List<DataInputActionType> actionTypes) {
            this.inputalphabet = ImmutableSet.copyOf(actionTypes);
            this.name2input = new HashMap();
            for (DataInputActionType inputType : actionTypes) {
                this.name2input.put(inputType.getName(), inputType);
            }
            return this;
        }

        public ImmutableBuilder setInputAlphabet(DataInputActionType ... actionTypes) {
            this.setInputAlphabet(Arrays.asList(actionTypes));
            return this;
        }

        public ImmutableBuilder setOutputAlphabet(List<DataOutputActionType> actionTypes) {
            this.outputalphabet = ImmutableSet.copyOf(actionTypes);
            this.name2output = new HashMap();
            for (DataOutputActionType outputType : actionTypes) {
                this.name2output.put(outputType.getName(), outputType);
            }
            return this;
        }

        public ImmutableBuilder setOutputAlphabet(DataOutputActionType ... actionTypes) {
            this.setOutputAlphabet(Arrays.asList(actionTypes));
            return this;
        }

        private Pair<String, List<String>> parseAction(String actionString) {
            int startIndex = actionString.indexOf("(");
            int endIndex = actionString.indexOf(")");
            String name = actionString.substring(0, startIndex).trim();
            String[] params = actionString.substring(startIndex + 1, endIndex).trim().split("\\s*,\\s*");
            return new Pair((Object)name, Arrays.asList(params));
        }

        private SymbolicInputAction parseInput(String inputStr) {
            Pair<String, List<String>> name_params = this.parseAction(inputStr);
            DataInputActionType actionType = this.name2input.get(name_params.getValue0());
            SymbolicInputAction input = new SymbolicInputAction(actionType, (List)name_params.getValue1());
            return input;
        }

        private SymbolicOutputAction parseOutput(String inputStr) {
            Pair<String, List<String>> name_params = this.parseAction(inputStr);
            DataOutputActionType actionType = this.name2output.get(name_params.getValue0());
            SymbolicOutputAction input = new SymbolicOutputAction(actionType, (List)name_params.getValue1());
            return input;
        }

        public ImmutableBuilder setStartState(Location startLocation) {
            this.startState = new DataLocationState(startLocation);
            return this;
        }

        public ImmutableBuilder setStartState(DataLocationState startState) {
            this.startState = startState;
            return this;
        }

        public ImmutableBuilder setStartState(Location startLocation, HashMap<VariableSymbol, Value> statevars) {
            this.startState = new DataLocationState(startLocation, statevars);
            return this;
        }

        public ImmutableBuilder setConstants(Map<VariableSymbol, Value> constants) {
            this.constants = ImmutableMap.copyOf(constants);
            return this;
        }

        public ImmutableBuilder addFromMealyModel(MealyModel model) {
            for (SymbolicMealyTransition trans : model.getModelTransitions()) {
                this.addTransition((Location)trans.getSource(), (Location)trans.getDestination(), trans.getInput(), trans.getOutput());
            }
            this.setStartState((DataLocationState)model.getStartState());
            this.setConstants((Map<VariableSymbol, Value>)model.getConstants());
            return this;
        }

        protected void baseBuild() {
            this.locations = this.locationsBuilder.build();
            this.transitions = this.transitionsBuilder.build();
            this.loc2trans = this.loc2transBuilder.build();
        }
    }
}

