/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.efsm.mealy;

import statemachine.model.efsm.ia.IaNonDetModel;
import statemachine.model.efsm.ia.conversion.Conversion;
import statemachine.model.efsm.ia.file.Import;
import statemachine.model.efsm.mealy.MealyBaseModel;
import statemachine.model.efsm.mealy.MealyModel;
import statemachine.model.elements.action.BaseDataActionType;

public class MealyNonDetModel
extends MealyBaseModel {
    static int counter = 0;

    private MealyNonDetModel(ImmutableBuilder builder) {
        super(builder);
    }

    public static MealyNonDetModel fromMealyModel(MealyModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromMealyModel(model);
        return builder.build();
    }

    public static void printStatistics(String filename, String name) {
        IaNonDetModel iaModel = Import.register2IaModel(filename);
        MealyNonDetModel mealyModel = Conversion.IaModel2MealyModel(iaModel);
        MealyNonDetModel.printStatistics(mealyModel, name);
    }

    public static void printStatistics(MealyNonDetModel mealyModel, String name) {
        int num_locations = mealyModel.getLocations().size();
        int num_inputs = mealyModel.getInputAlphabet().size();
        int num_outputs = mealyModel.getOutputAlphabet().size();
        int num_trans = mealyModel.getModelTransitions().size();
        int num_constants = mealyModel.constants.size();
        int num_statevars = mealyModel.getStartState().getValues().size();
        int num_inparams = 0;
        int num_outparams = 0;
        for (BaseDataActionType type : mealyModel.getInputAlphabet()) {
            num_inparams += type.getParameterTypes().size();
        }
        for (BaseDataActionType type : mealyModel.getOutputAlphabet()) {
            num_outparams += type.getParameterTypes().size();
        }
        String formatRow = "||%1$-40.40s ||  %2$10.10s || %3$10.10s/%4$-10.10s ||  %5$10.10s ||  %6$10.10s ||  %7$10.10s || %8$10.10s/%9$-10.10s ||";
        String formatHeader = "||!%1$-40.40s ||!  %2$10.10s ||! %3$10.10s/%4$-10.10s ||!  %5$10.10s ||!  %6$10.10s ||!  %7$10.10s ||! %8$10.10s/%9$-10.10s ||";
        if (counter % 10000 == 0) {
            System.out.println(String.format(formatHeader, "model", "states", "inputs", "outputs", "transitions", "constants", "registers", "inparams", "outparams"));
        }
        System.out.println(String.format(formatRow, name, num_locations, num_inputs, num_outputs, num_trans, num_constants, num_statevars, num_inparams, num_outparams));
        ++counter;
    }

    public static void printSimpleStatistics(String filename) {
        IaNonDetModel iaModel = Import.register2IaModel(filename);
        MealyNonDetModel mealyModel = Conversion.IaModel2MealyModel(iaModel);
        int num_inputs = mealyModel.getInputAlphabet().size();
        int num_locations = mealyModel.getLocations().size();
        int num_outputs = mealyModel.getOutputAlphabet().size();
        int num_trans = mealyModel.getModelTransitions().size();
        int num_constants = mealyModel.constants.size();
        int num_statevars = mealyModel.getStartState().getValues().size();
        int num_inparams = 0;
        int num_outparams = 0;
        for (BaseDataActionType type : mealyModel.getInputAlphabet()) {
            num_inparams += type.getParameterTypes().size();
        }
        for (BaseDataActionType type : mealyModel.getOutputAlphabet()) {
            num_outparams += type.getParameterTypes().size();
        }
        String format = "locations:%1$-10.10s  inputs:%2$-10.10s outputs:%3$-10.10s  transitions:%4$-10.10s constants:%4$-10.10s statevars:%4$-10.10s inparams:%4$-10.10s outparams:%4$-10.10s ";
        System.out.println(String.format(format, num_locations, num_inputs, num_outputs, num_trans, num_constants, num_statevars, num_inparams, num_outparams));
    }

    public static final class ImmutableBuilder
    extends MealyBaseModel.ImmutableBuilder {
        public MealyNonDetModel build() {
            super.baseBuild();
            return new MealyNonDetModel(this);
        }
    }
}

