/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.efsm.mealy.conversion;

import org.antlr.symtab.PrimitiveType;
import org.antlr.symtab.Type;
import org.javatuples.Quartet;
import statemachine.model.efsm.mealy.MealyModel;
import statemachine.model.efsm.mealy.MealyNonDetModel;
import statemachine.model.efsm.mealy.conversion.TransitionLabelFormatter;
import statemachine.model.efsm.mealy.conversion.TransitionLabelParser;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.action.DataInputActionType;
import statemachine.model.elements.action.DataOutputActionType;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.elements.transition.SymbolicMealyTransition;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class LtsZip {
    public static TransitionLabelFormatter defaultTransitionLabelFormatter = (input, output, guard, update) -> {
        String guardStr = "";
        String updateStr = "";
        if (update.isPresent()) {
            updateStr = "{" + (String)update.get() + "}";
        }
        if (guard.isPresent()) {
            guardStr = "[" + (String)guard.get() + "]";
        }
        return input.asString() + guardStr + "/" + updateStr + output.asString();
    };
    public static TransitionLabelParser defaultTransitionLabelParser = new TransitionLabelParser(){

        @Override
        public Quartet<String, String, String, String> apply(String label) {
            String outputStr;
            String inputStr;
            int endIndex;
            int startIndex;
            String update = "";
            String guard = "";
            String[] parts = label.split("/");
            String input_guard = parts[0];
            String update_output = parts[1];
            if (input_guard.contains("[")) {
                startIndex = input_guard.indexOf("[");
                endIndex = input_guard.indexOf("]");
                guard = input_guard.substring(startIndex + 1, endIndex).trim();
                inputStr = input_guard.substring(0, startIndex).trim();
            } else {
                inputStr = input_guard.trim();
            }
            if (update_output.contains("{")) {
                startIndex = update_output.indexOf("{");
                endIndex = update_output.indexOf("}");
                update = update_output.substring(startIndex + 1, endIndex).trim();
                outputStr = update_output.substring(endIndex + 1).trim();
            } else {
                outputStr = update_output.trim();
            }
            return new Quartet((Object)inputStr, (Object)outputStr, (Object)guard, (Object)update);
        }
    };

    public static LtsNonDetModel zipMealy2Lts(MealyModel model, TransitionLabelFormatter transitionFormatter) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (SymbolicMealyTransition trans : model.getModelTransitions()) {
            String label = transitionFormatter.apply(trans.getInput(), trans.getOutput(), trans.getGuard(), trans.getUpdate());
            Action action = new Action(label);
            builder.addTransition(new LocationState(((Location)trans.getSource()).getName()), new LocationState(((Location)trans.getDestination()).getName()), action);
        }
        builder.setStartLocation(new LocationState(((Location)model.getStartLocation()).getName()));
        return builder.build();
    }

    public static LtsNonDetModel zipMealy2Lts(MealyModel model) {
        return LtsZip.zipMealy2Lts(model, defaultTransitionLabelFormatter);
    }

    public static MealyNonDetModel unzipLts2Mealy(LtsModel model, TransitionLabelParser labelParser) {
        MealyNonDetModel.ImmutableBuilder builder = new MealyNonDetModel.ImmutableBuilder();
        PrimitiveType integer = new PrimitiveType("INT");
        DataInputActionType A = new DataInputActionType("a", new Type[]{integer, integer});
        DataInputActionType B = new DataInputActionType("b", new Type[]{integer});
        DataOutputActionType OUT = new DataOutputActionType("OUT", new Type[]{integer, integer});
        DataOutputActionType OK = new DataOutputActionType("OK", new Type[]{integer});
        builder.setInputAlphabet(A, B);
        builder.setOutputAlphabet(OUT, OK);
        for (ActionTransition trans : model.getModelTransitions()) {
            String label = trans.getAction().getName();
            Quartet<String, String, String, String> input_output_guard_update = labelParser.apply(label);
            String input = (String)input_output_guard_update.getValue0();
            String output = (String)input_output_guard_update.getValue1();
            String guard = (String)input_output_guard_update.getValue2();
            String update = (String)input_output_guard_update.getValue3();
            builder.addTransition(new Location(((LocationState)trans.getSource()).getName()), new Location(((LocationState)trans.getDestination()).getName()), input, output, guard, update);
        }
        builder.setStartState(new Location(((LocationState)model.getStartLocation()).getName()));
        return builder.build();
    }

    public static MealyNonDetModel unzipLts2Mealy(LtsModel model) {
        return LtsZip.unzipLts2Mealy(model, defaultTransitionLabelParser);
    }
}

