/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.elements.action;

import com.google.common.collect.ImmutableList;
import org.antlr.symtab.Type;
import org.antlr.symtab.TypedSymbol;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import statemachine.model.elements.action.BaseDataActionType;
import statemachine.model.elements.action.Value;

@NonNullByDefault
public abstract class BaseConcreteAction
implements TypedSymbol {
    protected final Type type;
    protected final ImmutableList<Value> parameterValues;

    public BaseConcreteAction(Type actionType, Iterable<Value> values) {
        if (!(actionType instanceof BaseDataActionType)) {
            throw new IllegalArgumentException("type must be a DataAction type");
        }
        this.type = actionType;
        this.parameterValues = ImmutableList.copyOf(values);
    }

    public void setType(@Nullable Type type) {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<Value> getArgumentValues() {
        return this.parameterValues;
    }

    public String toString() {
        return this.type.getName() + this.parameterValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseConcreteAction other = (BaseConcreteAction)obj;
        if (!this.parameterValues.equals(other.parameterValues)) {
            return false;
        }
        return this.type.equals(other.type);
    }
}

