/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.elements.action;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import org.antlr.symtab.Type;
import org.antlr.symtab.TypedSymbol;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class BaseSymbolicAction<T extends Type>
implements TypedSymbol {
    protected final T type;
    protected final ImmutableList<String> symbolicParameters;

    public BaseSymbolicAction(T actionType) {
        this(actionType, new LinkedList<String>());
    }

    public BaseSymbolicAction(T actionType, Iterable<String> symbolicParameters) {
        this.type = actionType;
        this.symbolicParameters = ImmutableList.copyOf(symbolicParameters);
    }

    public ImmutableList<String> getSymbolicParameters() {
        return this.symbolicParameters;
    }

    public T getType() {
        return this.type;
    }

    public void setType(@Nullable Type type) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.symbolicParameters == null ? 0 : this.symbolicParameters.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseSymbolicAction other = (BaseSymbolicAction)obj;
        if (!this.symbolicParameters.equals(other.symbolicParameters)) {
            return false;
        }
        return this.type.equals(other.type);
    }

    public String asString() {
        String joined = String.join((CharSequence)",", this.symbolicParameters);
        return this.type.getName() + "(" + joined + ")";
    }

    public String toString() {
        return this.asString();
    }
}

