/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.elements.location;

import com.google.common.collect.ImmutableSortedSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import statemachine.interfaces.system.statemarkers.SystemState;
import statemachine.model.elements.data.TimerVariable;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.location.Timer;

public class TimersLocationState
implements SystemState {
    private final ImmutableSortedSet<Timer> timers;
    private final Location location;

    public TimersLocationState(Location location, Set<Timer> timers) {
        this.location = location;
        this.timers = timers == null ? ImmutableSortedSet.copyOf(new HashSet()) : ImmutableSortedSet.copyOf(timers);
    }

    public Location getLocation() {
        return this.location;
    }

    public ImmutableSortedSet<Timer> getTimers() {
        return this.timers;
    }

    public long getTimeUntilTimeout() {
        if (this.timers.isEmpty()) {
            return -1L;
        }
        return ((Timer)this.timers.first()).getTimeoutTime();
    }

    public Optional<Timer> getTimer(TimerVariable name) {
        for (Timer timer : this.timers) {
            if (!timer.getName().equals(name)) continue;
            return Optional.of(timer);
        }
        return Optional.empty();
    }

    public TreeSet<TimerVariable> getTimedOutTimers() {
        TreeSet<TimerVariable> timerVars = new TreeSet<TimerVariable>();
        for (Timer timer : this.timers) {
            if (timer.getTimeoutTime() != 0L) continue;
            timerVars.add(timer.getName());
        }
        return timerVars;
    }

    public TimersLocationState getNewStateAfterDelay(long time) {
        HashSet<Timer> newtimers = new HashSet<Timer>();
        for (Timer timer : this.timers) {
            long timeouttime = timer.getTimeoutTime() - time;
            if (timeouttime <= 0L) continue;
            newtimers.add(new Timer(timer.getName(), timeouttime));
        }
        return new TimersLocationState(this.location, newtimers);
    }

    public TimersLocationState getNewStateAfterIdleTime(long time) {
        HashSet<Timer> newtimers = new HashSet<Timer>();
        for (Timer timer : this.timers) {
            long timeouttime = timer.getTimeoutTime() - time;
            if (timeouttime < 0L) continue;
            newtimers.add(new Timer(timer.getName(), timeouttime));
        }
        return new TimersLocationState(this.location, newtimers);
    }

    public String toString() {
        return this.location.toString() + this.timers.toString();
    }

    public TimersLocationState removeTimedOutTimers() {
        HashSet<Timer> newtimers = new HashSet<Timer>();
        for (Timer timer : this.timers) {
            long timeouttime = timer.getTimeoutTime();
            if (timeouttime <= 0L) continue;
            newtimers.add(new Timer(timer.getName(), timeouttime));
        }
        return new TimersLocationState(this.location, newtimers);
    }
}

