/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.elements.transition;

import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.interfaces.model.transitions.ModelMealyTransition;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.data.TimerVariable;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.transition.Transition;

@NonNullByDefault
public final class MealyTimerTransition
extends Transition<Location>
implements ModelMealyTransition<InputAction, OutputAction, Location> {
    private static final InputAction timeout = new InputAction("timeout");
    private final InputAction input;
    private final OutputAction output;
    private final TimerVariable timedOutTimer;
    private final String update;

    public MealyTimerTransition(Location source, Location destination, InputAction input, OutputAction output, String update) {
        super(source, destination);
        this.timedOutTimer = null;
        this.input = input;
        this.output = output;
        this.update = update;
    }

    public MealyTimerTransition(Location source, Location destination, InputAction input, OutputAction output) {
        this(source, destination, input, output, null);
    }

    public MealyTimerTransition(Location source, Location destination, TimerVariable timer, OutputAction output, String update) {
        super(source, destination);
        this.timedOutTimer = timer;
        this.input = timeout;
        this.output = output;
        this.update = update;
    }

    public MealyTimerTransition(Location source, Location destination, TimerVariable timer, OutputAction output) {
        this(source, destination, timer, output, null);
    }

    @Override
    public InputAction getInput() {
        return this.input;
    }

    @Override
    public OutputAction getOutput() {
        return this.output;
    }

    public boolean isTimeout() {
        return this.input == timeout;
    }

    public Optional<TimerVariable> getTimedOutTimer() {
        if (this.timedOutTimer == null) {
            return Optional.empty();
        }
        return Optional.of(this.timedOutTimer);
    }

    public boolean hasUpdate() {
        return this.update != null;
    }

    public Optional<String> getUpdate() {
        if (this.update == null) {
            return Optional.empty();
        }
        return Optional.of(this.update);
    }

    @Override
    public String toString() {
        String updateStr = "";
        String inputStr = this.input.toString();
        if (this.hasUpdate()) {
            updateStr = this.update;
        }
        if (this.isTimeout()) {
            inputStr = inputStr + "[" + this.timedOutTimer + "]";
        }
        return super.toString() + " : " + inputStr + '/' + this.output.toString() + updateStr;
    }
}

