/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.fa;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import statemachine.interfaces.system.properties.InputDeterministic;
import statemachine.model.Util;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.fa.FaBaseModel;
import statemachine.model.fsm.fa.FaModel;

public class DfaModel
extends FaBaseModel
implements InputDeterministic<LocationState, InputAction, InputTransition> {
    private DfaModel(ImmutableBuilder builder) {
        super(builder);
        for (LocationState location : this.loc2trans.keySet()) {
            for (InputAction action : this.inputalphabet) {
                this.getSystemTransition(location, action);
            }
        }
    }

    public static DfaModel fromFaModel(FaModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromFaModel(model);
        return builder.build();
    }

    @Override
    public Optional<InputTransition> getSystemTransition(LocationState location, InputAction action) {
        ImmutableSet<@NonNull InputTransition> transitions = this.getModelTransitions(location, action);
        return Util.getOptionalTransition(transitions);
    }

    public static final class ImmutableBuilder
    extends FaBaseModel.ImmutableBuilder {
        public DfaModel build() {
            super.baseBuild();
            return new DfaModel(this);
        }
    }
}

