/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.fa;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.fa.FaModel;
import statemachine.model.fsm.moore.MooreBaseModel;
import statemachine.model.fsm.moore.MooreModel;

public abstract class FaBaseModel
extends MooreBaseModel
implements FaModel,
MooreModel {
    public static OutputAction ACCEPT = new OutputAction("ACCEPT");
    public static OutputAction REJECT = new OutputAction("REJECT");

    protected FaBaseModel(ImmutableBuilder builder) {
        super(builder);
    }

    @Override
    public boolean isAccepting(LocationState location) {
        return this.loc2output.get((Object)location) == ACCEPT;
    }

    public static class ImmutableBuilder
    extends MooreBaseModel.ImmutableBuilder {
        public void setAccepting(LocationState location) {
            this.loc2outputBuilder.put((Object)location, (Object)ACCEPT);
        }

        public ImmutableBuilder addFromFaModel(FaModel model) {
            for (InputTransition trans : model.getModelTransitions()) {
                this.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), trans.getInput());
            }
            for (LocationState location : model.getLocations()) {
                OutputAction output = model.isAccepting(location) ? ACCEPT : REJECT;
                this.addOutput(location, output);
            }
            this.setStartLocation((LocationState)model.getStartLocation());
            return this;
        }

        @Override
        protected void baseBuild() {
            this.outputalphabetBuilder.add((Object)REJECT);
            this.outputalphabetBuilder.add((Object)ACCEPT);
            ImmutableSet local_locations = this.locationsBuilder.build();
            ImmutableMap local_loc2output = this.loc2outputBuilder.build();
            for (LocationState location : local_locations) {
                if (local_loc2output.containsKey((Object)location)) continue;
                this.addOutput(location, REJECT);
            }
            super.baseBuild();
        }
    }
}

