/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.fa;

import statemachine.model.fsm.fa.FaBaseModel;
import statemachine.model.fsm.fa.FaModel;
import statemachine.model.fsm.fa.file.Import;
import statemachine.model.fsm.moore.MooreModel;

public class NfaModel
extends FaBaseModel
implements FaModel,
MooreModel {
    private NfaModel(ImmutableBuilder builder) {
        super(builder);
    }

    public static NfaModel fromFaModel(FaModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromFaModel(model);
        return builder.build();
    }

    public static void printSimpleStatistics(String filename) {
        NfaModel nfaModel = Import.dot2NfaModel(filename);
        int num_inputs = nfaModel.getInputAlphabet().size();
        int num_locations = nfaModel.getLocations().size();
        int num_outputs = nfaModel.getOutputAlphabet().size();
        int num_trans = nfaModel.getModelTransitions().size();
        String format = "states:%1$-10.10s  inputs:%2$-10.10s outputs:%3$-10.10s  transitions:%4$-10.10s";
        System.out.println(String.format(format, num_locations, num_inputs, num_outputs, num_trans));
    }

    public static final class ImmutableBuilder
    extends FaBaseModel.ImmutableBuilder {
        public NfaModel build() {
            super.baseBuild();
            return new NfaModel(this);
        }
    }
}

