/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.fa.conversion;

import org.javatuples.Pair;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.fa.FaModel;
import statemachine.model.fsm.fa.NfaModel;
import statemachine.model.fsm.fa.conversion.LocationLabelFormatter;
import statemachine.model.fsm.fa.conversion.LocationLabelParser;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class LtsZip {
    public static LocationLabelFormatter defaultLocationFormatter = new LocationLabelFormatter(){

        @Override
        public String apply(LocationState location, Boolean active) {
            String stateOutput = "REJECT";
            if (active.booleanValue()) {
                stateOutput = "ACCEPT";
            }
            return location.getName() + "|" + stateOutput;
        }
    };
    public static LocationLabelParser defaultLabelParser = new LocationLabelParser(){

        @Override
        public Pair<LocationState, Boolean> apply(String label) {
            String[] parts = label.split("|");
            LocationState location = new LocationState(parts[0].trim());
            Boolean accepting = false;
            if (parts[1].trim().equals("ACCEPT")) {
                accepting = true;
            }
            return new Pair((Object)location, (Object)accepting);
        }
    };

    public static LtsNonDetModel zipFa2Lts(FaModel model, LocationLabelFormatter locationFormatter) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (InputTransition trans : model.getModelTransitions()) {
            Action action = new Action(trans.getInput().getName());
            LocationState src = (LocationState)trans.getSource();
            LocationState dest = (LocationState)trans.getDestination();
            String formattedSrcLabel = locationFormatter.apply(src, model.isAccepting(src));
            String formattedDestLabel = locationFormatter.apply(dest, model.isAccepting(dest));
            LocationState newsrc = new LocationState(formattedSrcLabel);
            LocationState newdest = new LocationState(formattedDestLabel);
            builder.addTransition(newsrc, newdest, action);
        }
        builder.setStartLocation((LocationState)model.getStartLocation());
        return builder.build();
    }

    public static LtsNonDetModel zipFa2Lts(FaModel model) {
        return LtsZip.zipFa2Lts(model, defaultLocationFormatter);
    }

    public static NfaModel unzipLts2Fa(LtsModel model, LocationLabelParser labelParser) {
        NfaModel.ImmutableBuilder builder = new NfaModel.ImmutableBuilder();
        for (ActionTransition trans : model.getModelTransitions()) {
            String label = ((LocationState)trans.getSource()).getName();
            Pair<LocationState, Boolean> location_accepting = labelParser.apply(label);
            LocationState newsrc = (LocationState)location_accepting.getValue0();
            Boolean accepting = (Boolean)location_accepting.getValue1();
            if (accepting.booleanValue()) {
                builder.setAccepting(newsrc);
            }
            label = ((LocationState)trans.getDestination()).getName();
            location_accepting = labelParser.apply(label);
            LocationState newdest = (LocationState)location_accepting.getValue0();
            accepting = (Boolean)location_accepting.getValue1();
            if (accepting.booleanValue()) {
                builder.setAccepting(newdest);
            }
            InputAction input = new InputAction(trans.getAction().getName());
            builder.addTransition(newsrc, newdest, input);
        }
        String[] parts = ((LocationState)model.getStartLocation()).getName().split("|");
        LocationState startLocation = new LocationState(parts[0].trim());
        builder.setStartLocation(startLocation);
        return builder.build();
    }

    public static NfaModel unzipLts2Fa(LtsModel model) {
        return LtsZip.unzipLts2Fa(model, defaultLabelParser);
    }
}

