/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.fa.format;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.fa.FaModel;
import statemachine.model.fsm.fa.NfaModel;

public class Dot {
    public static NfaModel importNfaModel(List<String> lines) {
        NfaModel.ImmutableBuilder builder = new NfaModel.ImmutableBuilder();
        for (String line : lines) {
            int arrow;
            if (line.contains("__start0") && !line.contains("label")) {
                arrow = line.indexOf(45);
                String start = line.substring(arrow + 2).trim();
                LocationState startLocation = new LocationState(start);
                builder.setStartLocation(startLocation);
            }
            if (!line.contains("label")) continue;
            if (line.contains("doublecircle")) {
                int e1 = line.indexOf(91);
                String locationStr = line.substring(0, e1).trim();
                LocationState location = new LocationState(locationStr);
                builder.setAccepting(location);
            }
            if (!line.contains("->")) continue;
            arrow = line.indexOf(45);
            int attrlist = line.indexOf(91);
            int labelattr = line.indexOf("label", attrlist);
            int labelbegin = line.indexOf(34, labelattr);
            int labelend = line.lastIndexOf(34);
            String from = line.substring(0, arrow).trim();
            String to = line.substring(arrow + 2, attrlist).trim();
            String label = line.substring(labelbegin + 1, labelend).trim();
            LocationState src = new LocationState(from);
            LocationState dst = new LocationState(to);
            InputAction action = new InputAction(label);
            builder.addTransition(src, dst, action);
        }
        return builder.build();
    }

    private static String formatID(String id) {
        return id.contains(" ") ? "\"" + id + "\"" : id;
    }

    public static List<String> export(FaModel model) {
        String format;
        ArrayList locations = new ArrayList(model.getLocations());
        locations.sort((p1, p2) -> p1.getName().compareTo(p2.getName()));
        ArrayList transitions = new ArrayList(model.getModelTransitions());
        BiFunction<InputTransition, InputTransition, Integer> comparator = (trans1, trans2) -> ComparisonChain.start().compare((Comparable)((Object)((LocationState)trans1.getSource()).getName()), (Comparable)((Object)((LocationState)trans2.getSource()).getName())).compare((Comparable)((Object)((LocationState)trans1.getDestination()).getName()), (Comparable)((Object)((LocationState)trans2.getDestination()).getName())).compare((Comparable)((Object)trans1.getInput().getName()), (Comparable)((Object)trans2.getInput().getName())).result();
        transitions.sort(comparator::apply);
        String indent = "    ";
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("digraph g {");
        lines.add("");
        lines.add(indent + "__start0 [label=\"\" shape=\"none\"]");
        lines.add(indent + "__start0 -> " + Dot.formatID(((LocationState)model.getStartLocation()).getName()));
        lines.add("");
        for (LocationState location : locations) {
            String label = location.getName();
            String id = Dot.formatID(label);
            String shape = model.isAccepting(location) ? "doublecircle" : "circle";
            format = "%s%s [label=\"%s\" shape=\"%s\"]";
            lines.add(String.format(format, indent, id, label, shape));
        }
        lines.add("");
        for (InputTransition transition : transitions) {
            String src = Dot.formatID(((LocationState)transition.getSource()).getName());
            String dst = Dot.formatID(((LocationState)transition.getDestination()).getName());
            String label = transition.getInput().getName();
            format = "%s%s -> %s  [label=\"%s\"]";
            lines.add(String.format(format, indent, src, dst, label));
        }
        lines.add("}");
        return lines;
    }
}

