/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.fa.util;

import java.util.List;
import java.util.StringJoiner;
import statemachine.model.elements.action.InputAction;

public class TraceDiff {
    public List<InputAction> inputsSimular;
    public List<Boolean> isAccepting;
    public InputAction discriminatingInput;
    public boolean discriminatingInputForFirstAutomata;
    public boolean discriminatingAcceptingValueForFirstAutomata;
    public boolean isEqual;

    public boolean isEqual() {
        return this.isEqual;
    }

    public TraceDiff(List<InputAction> inputsSimular, List<Boolean> isAccepting) {
        this.inputsSimular = inputsSimular;
        this.isAccepting = isAccepting;
        if (isAccepting.size() + 1 != inputsSimular.size()) {
            throw new RuntimeException("for equal trace  the number of similar accepting  values should be one more then similar inputs in the trace");
        }
        this.isEqual = true;
    }

    public TraceDiff(List<InputAction> inputsSimular, List<Boolean> isAccepting, boolean discriminatingAcceptingValueForFirstAutomata) {
        if (isAccepting.size() != inputsSimular.size()) {
            throw new RuntimeException("for discriminating trace on accepting value the number of similar inputs and similar accepting values in the trace should be the same");
        }
        this.inputsSimular = inputsSimular;
        this.isAccepting = isAccepting;
        this.discriminatingAcceptingValueForFirstAutomata = discriminatingAcceptingValueForFirstAutomata;
        this.isEqual = false;
    }

    public TraceDiff(List<InputAction> inputsSimular, List<Boolean> isAccepting, InputAction discriminatingInput, boolean discriminatingInputForFirstAutomata) {
        this.inputsSimular = inputsSimular;
        this.isAccepting = isAccepting;
        this.discriminatingInputForFirstAutomata = discriminatingInputForFirstAutomata;
        this.discriminatingInput = discriminatingInput;
        if (isAccepting.size() != inputsSimular.size() + 1) {
            throw new RuntimeException("for  discriminating trace on input  the number of similar accepting  values should be one more then similar inputs in the trace");
        }
        this.isEqual = false;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(" ");
        for (int i = 0; i < this.inputsSimular.size(); ++i) {
            InputAction input = this.inputsSimular.get(i);
            boolean sourceIsAccepting = this.isAccepting.get(i);
            joiner.add(sourceIsAccepting + " " + input + " ");
        }
        if (this.isEqual()) {
            return "EQUAL: " + joiner.toString() + this.isAccepting.get(this.isAccepting.size() - 1);
        }
        if (this.isAccepting.size() == this.inputsSimular.size()) {
            boolean first = this.discriminatingAcceptingValueForFirstAutomata;
            boolean second = !first;
            return "DIFFERENT: " + joiner.toString() + first + "/" + second;
        }
        String diffinput = this.discriminatingInputForFirstAutomata ? this.discriminatingInput + "/MISSING" : "MISSING/" + this.discriminatingInput;
        return "DIFFERENT: " + joiner.toString() + this.isAccepting.get(this.isAccepting.size() - 1) + " " + diffinput;
    }
}

