/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.fa.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.fa.DfaModel;
import statemachine.model.fsm.fa.FaModel;
import statemachine.model.fsm.fa.util.TraceDiff;
import statemachine.util.LocationPair;

public class Util {
    public static InputAction epsilon = new InputAction("e");

    private static List<InputAction> getInputs(Map<LocationPair, Link> statePair2actionOnIncomingTransition, LocationPair startPair, LocationPair endPair) {
        ArrayList<InputAction> inputs = new ArrayList<InputAction>();
        LocationPair currentPair = endPair;
        while (!currentPair.equals(startPair)) {
            Link prevPairAndInput = statePair2actionOnIncomingTransition.get(currentPair);
            inputs.add(prevPairAndInput.input);
            currentPair = prevPairAndInput.previousLocationPair;
        }
        Collections.reverse(inputs);
        return inputs;
    }

    private static List<Boolean> getAcceptingValues(DfaModel machine, List<InputAction> inputs) {
        ArrayList<Boolean> acceptingValues = new ArrayList<Boolean>();
        LocationState location = machine.getStartLocation();
        acceptingValues.add(machine.isAccepting(location));
        for (InputAction input : inputs) {
            InputTransition transition = machine.getSystemTransition(location, input).get();
            location = (LocationState)transition.getDestination();
            acceptingValues.add(machine.isAccepting(location));
        }
        return acceptingValues;
    }

    public static TraceDiff compare(DfaModel machine1, DfaModel machine2, ImmutableSet<InputAction> inputAlphabet) {
        boolean startIsAccepting2;
        LocationState startLoc1 = machine1.getStartLocation();
        LocationState startLoc2 = machine2.getStartLocation();
        LocationPair startPair = new LocationPair(startLoc1, startLoc2);
        boolean startIsAccepting1 = machine1.isAccepting(startLoc1);
        if (startIsAccepting1 != (startIsAccepting2 = machine2.isAccepting(startLoc2))) {
            ArrayList<InputAction> inputs = new ArrayList<InputAction>();
            ArrayList<Boolean> acceptingValues = new ArrayList<Boolean>();
            return new TraceDiff(inputs, acceptingValues, startIsAccepting1);
        }
        HashMap<LocationPair, Link> statePair2actionOnIncomingTransition = new HashMap<LocationPair, Link>();
        HashSet<LocationPair> seenStatePairs = new HashSet<LocationPair>();
        LinkedList<LocationPair> locationPairsTodo = new LinkedList<LocationPair>();
        seenStatePairs.add(startPair);
        locationPairsTodo.add(startPair);
        while (!locationPairsTodo.isEmpty()) {
            LocationPair currentLocPair = (LocationPair)locationPairsTodo.remove();
            for (InputAction input : inputAlphabet) {
                boolean isAccepting2;
                List<InputAction> inputs;
                Optional<InputTransition> trans1 = machine1.getSystemTransition(currentLocPair.left, input);
                Optional<InputTransition> trans2 = machine2.getSystemTransition(currentLocPair.right, input);
                if (trans1.isPresent() != trans2.isPresent()) {
                    boolean discriminatingInputForFirstAutomata;
                    InputAction discriminatingInput;
                    if (trans1.isPresent()) {
                        discriminatingInput = trans1.get().getInput();
                        discriminatingInputForFirstAutomata = true;
                    } else {
                        discriminatingInput = trans2.get().getInput();
                        discriminatingInputForFirstAutomata = false;
                    }
                    inputs = Util.getInputs(statePair2actionOnIncomingTransition, startPair, currentLocPair);
                    List<Boolean> acceptingValues = Util.getAcceptingValues(machine1, inputs);
                    return new TraceDiff(inputs, acceptingValues, discriminatingInput, discriminatingInputForFirstAutomata);
                }
                if (!trans1.isPresent()) continue;
                boolean isAccepting1 = machine1.isAccepting((LocationState)trans1.get().getDestination());
                if (isAccepting1 == (isAccepting2 = machine2.isAccepting((LocationState)trans2.get().getDestination()))) {
                    LocationPair destinationPair = new LocationPair((LocationState)trans1.get().getDestination(), (LocationState)trans2.get().getDestination());
                    if (seenStatePairs.contains(destinationPair)) continue;
                    seenStatePairs.add(destinationPair);
                    locationPairsTodo.add(destinationPair);
                    statePair2actionOnIncomingTransition.put(destinationPair, new Link(currentLocPair, input));
                    continue;
                }
                inputs = Util.getInputs(statePair2actionOnIncomingTransition, startPair, currentLocPair);
                List<Boolean> acceptingValues = Util.getAcceptingValues(machine1, inputs);
                inputs.add(input);
                return new TraceDiff(inputs, acceptingValues, isAccepting1);
            }
        }
        return null;
    }

    public static TraceDiff compare(DfaModel machine1, DfaModel machine2) {
        return Util.compare(machine1, machine2, machine1.getInputAlphabet());
    }

    public static HashSet<LocationState> getReachableStates(FaModel model, LocationState location, InputAction input) {
        HashSet<LocationState> currentLocs = new HashSet<LocationState>();
        ImmutableSet transitions = model.getModelTransitions(location, input);
        for (InputTransition transition : transitions) {
            currentLocs.add((LocationState)transition.getDestination());
        }
        return currentLocs;
    }

    private static void getEpsilonReachableStatesHelper(FaModel model, HashSet<LocationState> seen, HashSet<LocationState> todo) {
        HashSet<LocationState> reachable_locations = new HashSet<LocationState>();
        for (LocationState location : todo) {
            seen.add(location);
            reachable_locations.addAll(Util.getReachableStates(model, location, epsilon));
        }
        todo.addAll(reachable_locations);
        todo.removeAll(seen);
    }

    public static HashSet<LocationState> getEpsilonReachableStates(FaModel model, LocationState location) {
        HashSet<LocationState> seen = new HashSet<LocationState>();
        seen.add(location);
        HashSet<LocationState> todo = Util.getReachableStates(model, location, epsilon);
        todo.removeAll(seen);
        while (!todo.isEmpty()) {
            Util.getEpsilonReachableStatesHelper(model, seen, todo);
        }
        return seen;
    }

    private static HashSet<LocationState> getDestNfaLocationSet(FaModel model, HashSet<LocationState> locations, InputAction input) {
        HashSet<LocationState> result_locations = new HashSet<LocationState>();
        HashSet<LocationState> reachable_locations = new HashSet<LocationState>();
        for (LocationState location : locations) {
            reachable_locations.addAll(Util.getReachableStates(model, location, input));
        }
        result_locations.addAll(reachable_locations);
        for (LocationState location : reachable_locations) {
            result_locations.addAll(Util.getEpsilonReachableStates(model, location));
        }
        return result_locations;
    }

    private static String getName(HashSet<LocationState> locations) {
        ArrayList<LocationState> sortedLocations = new ArrayList<LocationState>(locations);
        sortedLocations.sort((p1, p2) -> p1.getName().compareTo(p2.getName()));
        String name = String.join((CharSequence)",", sortedLocations.stream().map(loc -> loc.getName()).collect(Collectors.toList()));
        return "{" + name + "}";
    }

    private static boolean isAccepting(FaModel model, HashSet<LocationState> destNfaLocationSet) {
        for (LocationState location : destNfaLocationSet) {
            if (!model.isAccepting(location)) continue;
            return true;
        }
        return false;
    }

    public static DfaModel determinize(FaModel model) {
        DfaModel.ImmutableBuilder builder = new DfaModel.ImmutableBuilder();
        ArrayList inputs = new ArrayList(model.getInputAlphabet());
        inputs.remove(epsilon);
        LocationState start = (LocationState)model.getStartLocation();
        HashSet<LocationState> startNfaLocationSet = Util.getEpsilonReachableStates(model, start);
        LocationState startDfaLocation = new LocationState(Util.getName(startNfaLocationSet));
        builder.setStartLocation(startDfaLocation);
        if (Util.isAccepting(model, startNfaLocationSet)) {
            builder.setAccepting(startDfaLocation);
        }
        LinkedList<HashSet<LocationState>> todo = new LinkedList<HashSet<LocationState>>();
        HashSet<LocationState> seenDfaLocations = new HashSet<LocationState>();
        HashSet<String> seenTransitions = new HashSet<String>();
        seenDfaLocations.add(startDfaLocation);
        todo.add(startNfaLocationSet);
        while (!todo.isEmpty()) {
            HashSet sourceNfaLocationSet = (HashSet)todo.remove();
            LocationState sourceDfaLocation = new LocationState(Util.getName(sourceNfaLocationSet));
            for (InputAction input : inputs) {
                HashSet<LocationState> destNfaLocationSet = Util.getDestNfaLocationSet(model, sourceNfaLocationSet, input);
                LocationState destDfaLocation = new LocationState(Util.getName(destNfaLocationSet));
                if (destDfaLocation.getName().equals("{}")) continue;
                String transString = sourceDfaLocation + "_" + destDfaLocation + "_" + input;
                if (!seenTransitions.contains(transString)) {
                    builder.addTransition(sourceDfaLocation, destDfaLocation, input);
                    seenTransitions.add(transString);
                }
                if (seenDfaLocations.contains(destDfaLocation)) continue;
                seenDfaLocations.add(destDfaLocation);
                todo.add(destNfaLocationSet);
                if (!Util.isAccepting(model, destNfaLocationSet)) continue;
                builder.setAccepting(destDfaLocation);
            }
        }
        return builder.build();
    }

    static class Link {
        public LocationPair previousLocationPair;
        public InputAction input;

        public Link(LocationPair previousLocationPair, InputAction input) {
            this.previousLocationPair = previousLocationPair;
            this.input = input;
        }
    }
}

