/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.ia;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringJoiner;
import org.eclipse.jdt.annotation.NonNull;
import statemachine.model.elements.action.HiddenAction;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.HiddenTransition;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.elements.transition.Transition;
import statemachine.model.fsm.ia.IaModel;

public abstract class IaBaseModel
implements IaModel {
    protected final ImmutableSet<InputAction> inputalphabet;
    protected final ImmutableSet<OutputAction> outputalphabet;
    protected final ImmutableSet<HiddenAction> hiddenalphabet;
    private final LocationState startLocation;
    private final ImmutableSet<LocationState> locations;
    private final ImmutableSet<InputTransition> inputTransitions;
    private final ImmutableSet<OutputTransition> outputTransitions;
    protected final ImmutableSet<HiddenTransition> hiddenTransitions;
    protected final ImmutableSetMultimap<LocationState, InputTransition> loc2inputtrans;
    protected final ImmutableSetMultimap<LocationState, OutputTransition> loc2outputtrans;
    protected final ImmutableSetMultimap<LocationState, HiddenTransition> loc2hiddentrans;

    protected IaBaseModel(ImmutableBuilder builder) {
        this.inputalphabet = builder.inputalphabet;
        this.outputalphabet = builder.outputalphabet;
        this.hiddenalphabet = builder.hiddenalphabet;
        this.startLocation = builder.startLocation;
        this.locations = builder.locations;
        this.inputTransitions = builder.inputTransitions;
        this.outputTransitions = builder.outputTransitions;
        this.hiddenTransitions = builder.hiddenTransitions;
        this.loc2inputtrans = builder.loc2inputtrans;
        this.loc2outputtrans = builder.loc2outputtrans;
        this.loc2hiddentrans = builder.loc2hiddentrans;
    }

    @Override
    public @NonNull LocationState getStartLocation() {
        return this.startLocation;
    }

    @Override
    public @NonNull LocationState getStartState() {
        return this.startLocation;
    }

    @Override
    public ImmutableSet<LocationState> getLocations() {
        return this.locations;
    }

    @Override
    public ImmutableSet<Transition<LocationState>> getModelTransitions() {
        HashSet<Transition> set = new HashSet<Transition>();
        set.addAll((Collection<Transition>)this.inputTransitions);
        set.addAll((Collection<Transition>)this.outputTransitions);
        set.addAll((Collection<Transition>)this.hiddenTransitions);
        return ImmutableSet.copyOf(set);
    }

    @Override
    public ImmutableSet<Transition<LocationState>> getModelTransitions(LocationState location) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        transitionsBuilder.addAll((Iterable)this.loc2inputtrans.get((Object)location));
        transitionsBuilder.addAll((Iterable)this.loc2outputtrans.get((Object)location));
        transitionsBuilder.addAll((Iterable)this.loc2hiddentrans.get((Object)location));
        return transitionsBuilder.build();
    }

    @Override
    public ImmutableSet<InputAction> getInputAlphabet() {
        return this.inputalphabet;
    }

    @Override
    public ImmutableSet<OutputAction> getOutputAlphabet() {
        return this.outputalphabet;
    }

    @Override
    public ImmutableSet<HiddenAction> getHiddenAlphabet() {
        return this.hiddenalphabet;
    }

    @Override
    public @NonNull ImmutableSet<@NonNull InputTransition> getModelInputTransitions() {
        return this.inputTransitions;
    }

    @Override
    public @NonNull ImmutableSet<@NonNull OutputTransition> getModelOutputTransitions() {
        return this.outputTransitions;
    }

    @Override
    public @NonNull ImmutableSet<@NonNull HiddenTransition> getModelHiddenTransitions() {
        return this.hiddenTransitions;
    }

    @Override
    public @NonNull ImmutableSet<@NonNull InputTransition> getModelInputTransitions(@NonNull LocationState location) {
        return this.loc2inputtrans.get((Object)location);
    }

    @Override
    public @NonNull ImmutableSet<@NonNull OutputTransition> getModelOutputTransitions(@NonNull LocationState location) {
        return this.loc2outputtrans.get((Object)location);
    }

    @Override
    public @NonNull ImmutableSet<@NonNull HiddenTransition> getModelHiddenTransitions(@NonNull LocationState location) {
        return this.loc2hiddentrans.get((Object)location);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull InputTransition> getModelInputTransitions(@NonNull LocationState location, @NonNull InputAction action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2inputtrans.get((Object)location);
        for (InputTransition transition : transitions) {
            if (!transition.getInput().equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull OutputTransition> getModelOutputTransitions(@NonNull LocationState location, @NonNull OutputAction action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2outputtrans.get((Object)location);
        for (OutputTransition transition : transitions) {
            if (!transition.getOutput().equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull HiddenTransition> getModelHiddenTransitions(@NonNull LocationState location, @NonNull HiddenAction action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2hiddentrans.get((Object)location);
        for (HiddenTransition transition : transitions) {
            if (!transition.getHiddenAction().equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("start: " + this.startLocation);
        joiner.add("locations:");
        for (LocationState location : this.getLocations()) {
            joiner.add(location.toString());
        }
        joiner.add("input transitions:");
        for (Transition transition : this.getModelInputTransitions()) {
            joiner.add(((InputTransition)transition).toString());
        }
        joiner.add("output transitions:");
        for (Transition transition : this.getModelOutputTransitions()) {
            joiner.add(((OutputTransition)transition).toString());
        }
        joiner.add("hidden transitions:");
        for (Transition transition : this.getModelHiddenTransitions()) {
            joiner.add(((HiddenTransition)transition).toString());
        }
        joiner.add("");
        return joiner.toString();
    }

    public static abstract class ImmutableBuilder {
        protected ImmutableSet<InputAction> inputalphabet;
        protected ImmutableSet<OutputAction> outputalphabet;
        protected ImmutableSet<HiddenAction> hiddenalphabet;
        protected LocationState startLocation;
        protected ImmutableSet<LocationState> locations;
        protected ImmutableSet<InputTransition> inputTransitions;
        protected ImmutableSet<OutputTransition> outputTransitions;
        protected ImmutableSet<HiddenTransition> hiddenTransitions;
        protected ImmutableSetMultimap<LocationState, InputTransition> loc2inputtrans;
        protected ImmutableSetMultimap<LocationState, OutputTransition> loc2outputtrans;
        protected ImmutableSetMultimap<LocationState, HiddenTransition> loc2hiddentrans;
        protected ImmutableSet.Builder<LocationState> locationsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<InputTransition> inputTransitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<OutputTransition> outputTransitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<HiddenTransition> hiddenTransitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<InputAction> inputalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<OutputAction> outputalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<HiddenAction> hiddenalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSetMultimap.Builder<LocationState, InputTransition> loc2inputransBuilder = ImmutableSetMultimap.builder();
        protected ImmutableSetMultimap.Builder<LocationState, OutputTransition> loc2outputransBuilder = ImmutableSetMultimap.builder();
        protected ImmutableSetMultimap.Builder<LocationState, HiddenTransition> loc2hiddentransBuilder = ImmutableSetMultimap.builder();

        public ImmutableBuilder addInputTransition(LocationState src, LocationState dst, InputAction action) {
            this.locationsBuilder.add((Object[])new LocationState[]{src, dst});
            this.inputalphabetBuilder.add((Object)action);
            InputTransition transition = new InputTransition(src, dst, action);
            this.inputTransitionsBuilder.add((Object)transition);
            this.loc2inputransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addOutputTransition(LocationState src, LocationState dst, OutputAction action) {
            this.locationsBuilder.add((Object[])new LocationState[]{src, dst});
            this.outputalphabetBuilder.add((Object)action);
            OutputTransition transition = new OutputTransition(src, dst, action);
            this.outputTransitionsBuilder.add((Object)transition);
            this.loc2outputransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addHiddenTransition(LocationState src, LocationState dst, HiddenAction action) {
            this.locationsBuilder.add((Object[])new LocationState[]{src, dst});
            this.hiddenalphabetBuilder.add((Object)action);
            HiddenTransition transition = new HiddenTransition(src, dst, action);
            this.hiddenTransitionsBuilder.add((Object)transition);
            this.loc2hiddentransBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder setStartLocation(LocationState startLocation) {
            this.startLocation = startLocation;
            return this;
        }

        protected ImmutableBuilder addFromIAModel(IaModel model) {
            for (Transition trans : model.getModelInputTransitions()) {
                this.addInputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((InputTransition)trans).getInput());
            }
            for (Transition trans : model.getModelOutputTransitions()) {
                this.addOutputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((OutputTransition)trans).getOutput());
            }
            for (Transition trans : model.getModelHiddenTransitions()) {
                this.addHiddenTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((HiddenTransition)trans).getHiddenAction());
            }
            this.setStartLocation((LocationState)model.getStartLocation());
            return this;
        }

        protected void baseBuild() {
            this.inputalphabet = this.inputalphabetBuilder.build();
            this.outputalphabet = this.outputalphabetBuilder.build();
            this.hiddenalphabet = this.hiddenalphabetBuilder.build();
            this.locations = this.locationsBuilder.build();
            this.inputTransitions = this.inputTransitionsBuilder.build();
            this.outputTransitions = this.outputTransitionsBuilder.build();
            this.hiddenTransitions = this.hiddenTransitionsBuilder.build();
            this.loc2outputtrans = this.loc2outputransBuilder.build();
            this.loc2inputtrans = this.loc2inputransBuilder.build();
            this.loc2hiddentrans = this.loc2hiddentransBuilder.build();
        }
    }
}

