/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.ia;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import statemachine.interfaces.system.properties.OutputDetermined;
import statemachine.model.Util;
import statemachine.model.elements.action.BaseActionType;
import statemachine.model.elements.action.HiddenAction;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.fsm.ia.IaBaseModel;
import statemachine.model.fsm.ia.IaDetModelInterface;
import statemachine.model.fsm.ia.IaModel;

public class IaBehaviorDetModel
extends IaBaseModel
implements IaDetModelInterface,
OutputDetermined<LocationState, OutputTransition> {
    private IaBehaviorDetModel(ImmutableBuilder builder) {
        super(builder);
        for (LocationState location : this.loc2inputtrans.keySet()) {
            for (BaseActionType action : this.inputalphabet) {
                this.getSystemTransition(location, (InputAction)action);
            }
        }
        for (LocationState location : this.loc2outputtrans.keySet()) {
            for (BaseActionType action : this.outputalphabet) {
                this.getSystemTransition(location, (OutputAction)action);
            }
        }
        for (LocationState location : this.loc2outputtrans.keySet()) {
            this.getSystemTriggeredOutputTransition(location);
            ImmutableSet<OutputTransition> immutableSet = this.getModelOutputTransitions(location);
        }
    }

    public static IaBehaviorDetModel fromIAModel(IaModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromIAModel(model);
        return builder.build();
    }

    @Override
    public Optional<InputTransition> getSystemTransition(LocationState location, InputAction action) {
        ImmutableSet<@NonNull InputTransition> transitions = this.getModelInputTransitions(location, action);
        return Util.getOptionalTransition(transitions);
    }

    @Override
    public Optional<OutputTransition> getSystemTransition(LocationState location, OutputAction action) {
        ImmutableSet<@NonNull OutputTransition> transitions = this.getModelOutputTransitions(location, action);
        return Util.getOptionalTransition(transitions);
    }

    @Override
    public LocationState getSystemsNextState(LocationState state, InputAction input) {
        Optional<InputTransition> optTrans = this.getSystemTransition(state, input);
        if (optTrans.isPresent()) {
            return (LocationState)optTrans.get().getDestination();
        }
        return state;
    }

    @Override
    public LocationState getSystemsNextState(LocationState state, OutputAction output) {
        Optional<OutputTransition> optTrans = this.getSystemTransition(state, output);
        if (optTrans.isPresent()) {
            return (LocationState)optTrans.get().getDestination();
        }
        return state;
    }

    @Override
    public Optional<OutputTransition> getSystemTriggeredOutputTransition(LocationState state) {
        ImmutableSet<@NonNull OutputTransition> output_transitions = this.getModelOutputTransitions(state);
        return Util.getOptionalTransition(output_transitions);
    }

    public static final class ImmutableBuilder
    extends IaBaseModel.ImmutableBuilder {
        public IaBehaviorDetModel build() {
            super.baseBuild();
            return new IaBehaviorDetModel(this);
        }

        @Override
        public ImmutableBuilder addHiddenTransition(LocationState src, LocationState dst, HiddenAction action) {
            throw new UnsupportedOperationException();
        }
    }
}

