/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.ia.conversion;

import statemachine.model.elements.action.Action;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.elements.transition.Transition;
import statemachine.model.fsm.ia.IaModel;
import statemachine.model.fsm.ia.IaNonDetModel;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class LtsZip {
    public static LtsNonDetModel zipIa2Lts(IaModel model) {
        Action action;
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (Transition trans : model.getModelInputTransitions()) {
            action = new Action("?" + ((InputTransition)trans).getInput().getName());
            builder.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), action);
        }
        for (Transition trans : model.getModelOutputTransitions()) {
            action = new Action("!" + ((OutputTransition)trans).getOutput().getName());
            builder.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), action);
        }
        builder.setStartLocation((LocationState)model.getStartLocation());
        return builder.build();
    }

    public static IaNonDetModel unzipLts2IaS(LtsModel model) {
        IaNonDetModel.ImmutableBuilder builder = new IaNonDetModel.ImmutableBuilder();
        for (ActionTransition trans : model.getModelTransitions()) {
            String label = trans.getAction().getName();
            if (label.trim().startsWith("?")) {
                InputAction input = new InputAction(label.trim().substring(1).trim());
                builder.addInputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), input);
                continue;
            }
            if (label.trim().startsWith("!")) {
                OutputAction output = new OutputAction(label.trim().substring(1).trim());
                builder.addOutputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), output);
                continue;
            }
            throw new RuntimeException("cannot unzip label: " + label);
        }
        builder.setStartLocation((LocationState)model.getStartLocation());
        return builder.build();
    }
}

