/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.iafa;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.elements.transition.Transition;
import statemachine.model.fsm.iafa.IaFaModel;
import statemachine.model.fsm.iamoore.IaMooreBaseModel;

public abstract class IaFaBaseModel
extends IaMooreBaseModel
implements IaFaModel {
    public static OutputAction ACCEPT = new OutputAction("ACCEPT");
    public static OutputAction REJECT = new OutputAction("REJECT");

    protected IaFaBaseModel(ImmutableBuilder builder) {
        super(builder);
    }

    @Override
    public boolean isAccepting(LocationState location) {
        return this.loc2output.get((Object)location) == ACCEPT;
    }

    public static class ImmutableBuilder
    extends IaMooreBaseModel.ImmutableBuilder {
        public void setAccepting(LocationState location) {
            this.loc2outputBuilder.put((Object)location, (Object)ACCEPT);
        }

        public ImmutableBuilder addFromIaFaModel(IaFaModel model) {
            for (Transition trans : model.getModelInputTransitions()) {
                this.addInputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((InputTransition)trans).getInput());
            }
            for (Transition trans : model.getModelOutputTransitions()) {
                this.addOutputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((OutputTransition)trans).getOutput());
            }
            for (LocationState location : model.getLocations()) {
                OutputAction output = model.isAccepting(location) ? ACCEPT : REJECT;
                this.addOutput(location, output);
            }
            this.setStartLocation((LocationState)model.getStartLocation());
            return this;
        }

        @Override
        protected void baseBuild() {
            this.outputalphabetBuilder.add((Object)REJECT);
            this.outputalphabetBuilder.add((Object)ACCEPT);
            ImmutableSet local_locations = this.locationsBuilder.build();
            ImmutableMap local_loc2output = this.loc2outputBuilder.build();
            for (LocationState location : local_locations) {
                if (local_loc2output.containsKey((Object)location)) continue;
                this.addOutput(location, REJECT);
            }
            super.baseBuild();
            LinkedList trans_outputs = new LinkedList(this.outputalphabet);
            trans_outputs.remove(REJECT);
            trans_outputs.remove(ACCEPT);
            this.outputalphabet = ImmutableSet.copyOf(trans_outputs);
        }
    }
}

