/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.iafa.conversion;

import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.elements.transition.Transition;
import statemachine.model.fsm.fa.NfaModel;
import statemachine.model.fsm.ia.IaNonDetModel;
import statemachine.model.fsm.ia.conversion.LtsZip;
import statemachine.model.fsm.iafa.IaFaModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class IaFaZip {
    public static LtsNonDetModel zipIaFa2Lts(IaFaModel model) {
        return LtsZip.zipIa2Lts(IaFaZip.zipIaFa2Ia(model));
    }

    public static IaNonDetModel zipIaFa2Ia(IaFaModel model) {
        IaNonDetModel.ImmutableBuilder builder = new IaNonDetModel.ImmutableBuilder();
        for (Transition trans : model.getModelInputTransitions()) {
            builder.addInputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((InputTransition)trans).getInput());
        }
        for (Transition trans : model.getModelOutputTransitions()) {
            builder.addOutputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((OutputTransition)trans).getOutput());
        }
        builder.setStartLocation((LocationState)model.getStartLocation());
        return builder.build();
    }

    public static NfaModel zipIaFa2Fa(IaFaModel model) {
        NfaModel.ImmutableBuilder builder = new NfaModel.ImmutableBuilder();
        for (Transition trans : model.getModelInputTransitions()) {
            builder.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), new InputAction("?" + ((InputTransition)trans).getInput().getName()));
        }
        for (Transition trans : model.getModelOutputTransitions()) {
            builder.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), new InputAction("!" + ((OutputTransition)trans).getOutput().getName()));
        }
        for (LocationState location : model.getLocations()) {
            if (!model.isAccepting(location)) continue;
            builder.setAccepting(location);
        }
        builder.setStartLocation((LocationState)model.getStartLocation());
        return builder.build();
    }
}

