/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.iafa.format;

import java.util.LinkedList;
import java.util.List;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.elements.transition.Transition;
import statemachine.model.fsm.iafa.IaFaModel;
import statemachine.model.fsm.iafa.IaFaNonDetModel;

public class Dot {
    public static IaFaNonDetModel importIaFaModel(List<String> lines) {
        IaFaNonDetModel.ImmutableBuilder builder = new IaFaNonDetModel.ImmutableBuilder();
        for (String line : lines) {
            int e2;
            int e1;
            if (line.contains("__start0") && !line.contains("label")) {
                e1 = line.indexOf(45);
                e2 = line.indexOf(59);
                String start = line.substring(e1 + 2, e2).trim();
                LocationState startLocation = new LocationState(start);
                builder.setStartLocation(startLocation);
            }
            if (!line.contains("label")) continue;
            if (line.contains("->")) {
                e1 = line.indexOf(45);
                e2 = line.indexOf(91);
                int b3 = line.indexOf(34);
                int e3 = line.lastIndexOf(34);
                String from = line.substring(0, e1).trim();
                String to = line.substring(e1 + 2, e2).trim();
                String label = line.substring(b3 + 1, e3).trim();
                LocationState src = new LocationState(from);
                LocationState dst = new LocationState(to);
                if (label.trim().startsWith("?")) {
                    InputAction input = new InputAction(label.trim().substring(1).trim());
                    builder.addInputTransition(src, dst, input);
                } else if (label.trim().startsWith("!")) {
                    OutputAction output = new OutputAction(label.trim().substring(1).trim());
                    builder.addOutputTransition(src, dst, output);
                } else {
                    throw new RuntimeException("cannot unzip label: " + label);
                }
            }
            if (!line.contains("doublecircle")) continue;
            e1 = line.indexOf(91);
            String locationStr = line.substring(0, e1).trim();
            LocationState location = new LocationState(locationStr);
            builder.setAccepting(location);
        }
        return builder.build();
    }

    public static List<String> export(IaFaModel model) {
        String indent = "    ";
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("digraph g {");
        lines.add("");
        lines.add(indent + "__start0 [label=\"\" shape=\"none\"]");
        lines.add("");
        for (LocationState location : model.getLocations()) {
            if (model.isAccepting(location)) {
                lines.add(indent + location + " [shape=\"doublecircle\" label=\"" + location + "\"];");
                continue;
            }
            lines.add(indent + location + " [shape=\"circle\" label=\"" + location + "\"];");
        }
        for (Transition transition : model.getModelInputTransitions()) {
            lines.add(indent + transition.getSource() + " -> " + transition.getDestination() + " [label=\"?" + ((InputTransition)transition).getInput().getName() + "\"];");
        }
        for (Transition transition : model.getModelOutputTransitions()) {
            lines.add(indent + transition.getSource() + " -> " + transition.getDestination() + " [label=\"!" + ((OutputTransition)transition).getOutput().getName() + "\"];");
        }
        lines.add("");
        lines.add(indent + "__start0 -> " + model.getStartLocation() + ";");
        lines.add("}");
        return lines;
    }
}

