/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.iafa.walker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.interfaces.system.walker.StepInputOrOutputOrHidden;
import statemachine.model.elements.action.HiddenAction;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.HiddenTransition;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.fsm.iafa.IaFaNonDetModel;
import statemachine.model.fsm.iafa.walker.IaFaBaseWalker;

@NonNullByDefault
public class IaFaNonDetRandomWalker
extends IaFaBaseWalker<IaFaNonDetModel>
implements StepInputOrOutputOrHidden<LocationState, InputAction, OutputAction, HiddenAction> {
    private Random random;

    public IaFaNonDetRandomWalker(IaFaNonDetModel model, Random random) {
        super(model);
        this.random = random;
    }

    @Override
    public boolean checkInputPossible(InputAction action) {
        ImmutableSet<InputTransition> possibleTransitions = ((IaFaNonDetModel)this.model).getModelInputTransitions(this.currentLocation, action);
        return possibleTransitions.size() > 0;
    }

    @Override
    public boolean checkOutputPossible(OutputAction action) {
        ImmutableSet<OutputTransition> possibleTransitions = ((IaFaNonDetModel)this.model).getModelOutputTransitions(this.currentLocation, action);
        return possibleTransitions.size() > 0;
    }

    @Override
    public boolean checkHiddenPossible(HiddenAction action) {
        ImmutableSet<HiddenTransition> possibleTransitions = ((IaFaNonDetModel)this.model).getModelHiddenTransitions(this.currentLocation, action);
        return possibleTransitions.size() > 0;
    }

    @Override
    public void stepInput(InputAction action) {
        ImmutableSet<InputTransition> possibleTransitions = ((IaFaNonDetModel)this.model).getModelInputTransitions(this.currentLocation, action);
        int numTrans = possibleTransitions.size();
        if (numTrans > 1) {
            ImmutableList list = possibleTransitions.asList();
            int index = this.random.nextInt(numTrans);
            this.currentLocation = (LocationState)((InputTransition)list.get(index)).getDestination();
        }
        if (numTrans == 1) {
            InputTransition t = (InputTransition)possibleTransitions.iterator().next();
            this.currentLocation = (LocationState)t.getDestination();
        }
    }

    @Override
    public void stepOutput(OutputAction action) {
        ImmutableSet<OutputTransition> possibleTransitions = ((IaFaNonDetModel)this.model).getModelOutputTransitions(this.currentLocation, action);
        int numTrans = possibleTransitions.size();
        if (numTrans > 1) {
            ImmutableList list = possibleTransitions.asList();
            int index = this.random.nextInt(numTrans);
            this.currentLocation = (LocationState)((OutputTransition)list.get(index)).getDestination();
        }
        if (numTrans == 1) {
            OutputTransition t = (OutputTransition)possibleTransitions.iterator().next();
            this.currentLocation = (LocationState)t.getDestination();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void stepHidden(HiddenAction action) {
        @NonNull ImmutableSet<@NonNull HiddenTransition> possibleTransitions = ((IaFaNonDetModel)this.model).getModelHiddenTransitions(this.currentLocation, action);
        int numTrans = possibleTransitions.size();
        if (numTrans > 1) {
            @NonNull ImmutableList list = possibleTransitions.asList();
            int index = this.random.nextInt(numTrans);
            this.currentLocation = (LocationState)((HiddenTransition)list.get(index)).getDestination();
        }
        if (numTrans == 1) {
            @NonNull HiddenTransition t = (HiddenTransition)possibleTransitions.iterator().next();
            this.currentLocation = (LocationState)t.getDestination();
        }
    }
}

