/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.iamoore;

import com.google.common.collect.ImmutableMap;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.elements.transition.Transition;
import statemachine.model.fsm.ia.IaBaseModel;
import statemachine.model.fsm.iamoore.IaMooreModel;

public abstract class IaMooreBaseModel
extends IaBaseModel
implements IaMooreModel {
    protected ImmutableMap<LocationState, OutputAction> loc2output;

    protected IaMooreBaseModel(ImmutableBuilder builder) {
        super(builder);
        this.loc2output = builder.loc2output;
    }

    @Override
    public OutputAction getOutputAt(LocationState location) {
        return (OutputAction)this.loc2output.get((Object)location);
    }

    public static class ImmutableBuilder
    extends IaBaseModel.ImmutableBuilder {
        protected ImmutableMap<LocationState, OutputAction> loc2output;
        protected ImmutableMap.Builder<LocationState, OutputAction> loc2outputBuilder = ImmutableMap.builder();

        public ImmutableBuilder addFromIaMooreModel(IaMooreModel model) {
            for (Transition trans : model.getModelInputTransitions()) {
                this.addInputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((InputTransition)trans).getInput());
            }
            for (Transition trans : model.getModelOutputTransitions()) {
                this.addOutputTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), ((OutputTransition)trans).getOutput());
            }
            this.setStartLocation((LocationState)model.getStartLocation());
            for (LocationState location : model.getLocations()) {
                OutputAction output = (OutputAction)model.getOutputAt(location);
                this.addOutput(location, output);
            }
            return this;
        }

        protected ImmutableBuilder addOutput(LocationState src, OutputAction output) {
            this.locationsBuilder.add((Object)src);
            this.outputalphabetBuilder.add((Object)output);
            this.loc2outputBuilder.put((Object)src, (Object)output);
            return this;
        }

        @Override
        protected void baseBuild() {
            this.loc2output = this.loc2outputBuilder.build();
            super.baseBuild();
        }
    }
}

