/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.iamoore;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import statemachine.interfaces.system.properties.InputDeterministic;
import statemachine.interfaces.system.properties.OutputDeterministic;
import statemachine.interfaces.system.properties.StateDeterministic;
import statemachine.model.Util;
import statemachine.model.elements.action.BaseActionType;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.elements.transition.OutputTransition;
import statemachine.model.fsm.iamoore.IaMooreBaseModel;
import statemachine.model.fsm.iamoore.IaMooreModel;

public class IaMooreDetModel
extends IaMooreBaseModel
implements StateDeterministic<LocationState, InputAction, OutputAction>,
InputDeterministic<LocationState, InputAction, InputTransition>,
OutputDeterministic<LocationState, OutputAction, OutputTransition> {
    private IaMooreDetModel(ImmutableBuilder builder) {
        super(builder);
        for (LocationState location : this.loc2inputtrans.keySet()) {
            for (BaseActionType action : this.inputalphabet) {
                this.getSystemTransition(location, (InputAction)action);
            }
        }
        for (LocationState location : this.loc2outputtrans.keySet()) {
            for (BaseActionType action : this.outputalphabet) {
                this.getSystemTransition(location, (OutputAction)action);
            }
        }
    }

    public static IaMooreDetModel fromIAModel(IaMooreModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromIaMooreModel(model);
        return builder.build();
    }

    @Override
    public Optional<InputTransition> getSystemTransition(LocationState location, InputAction action) {
        ImmutableSet<@NonNull InputTransition> transitions = this.getModelInputTransitions(location, action);
        return Util.getOptionalTransition(transitions);
    }

    @Override
    public Optional<OutputTransition> getSystemTransition(LocationState location, OutputAction action) {
        ImmutableSet<@NonNull OutputTransition> transitions = this.getModelOutputTransitions(location, action);
        return Util.getOptionalTransition(transitions);
    }

    @Override
    public LocationState getSystemsNextState(LocationState state, InputAction input) {
        Optional<InputTransition> optTrans = this.getSystemTransition(state, input);
        if (optTrans.isPresent()) {
            return (LocationState)optTrans.get().getDestination();
        }
        return state;
    }

    @Override
    public LocationState getSystemsNextState(LocationState state, OutputAction output) {
        Optional<OutputTransition> optTrans = this.getSystemTransition(state, output);
        if (optTrans.isPresent()) {
            return (LocationState)optTrans.get().getDestination();
        }
        return state;
    }

    public static final class ImmutableBuilder
    extends IaMooreBaseModel.ImmutableBuilder {
        @Override
        public ImmutableBuilder addOutput(LocationState src, OutputAction output) {
            super.addOutput(src, output);
            return this;
        }

        public IaMooreDetModel build() {
            super.baseBuild();
            return new IaMooreDetModel(this);
        }
    }
}

