/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.StringJoiner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsModel;

@NonNullByDefault
public abstract class LtsBaseModel
implements LtsModel {
    protected final ImmutableSet<Action> alphabet;
    private final LocationState startLocation;
    private final ImmutableSet<LocationState> locations;
    private final ImmutableSet<ActionTransition> transitions;
    protected final ImmutableSetMultimap<LocationState, ActionTransition> loc2trans;

    protected LtsBaseModel(ImmutableBuilder builder) {
        this.alphabet = builder.alphabet;
        this.locations = builder.locations;
        this.transitions = builder.transitions;
        this.startLocation = builder.startLocation;
        this.loc2trans = builder.loc2trans;
    }

    @Override
    public @NonNull LocationState getStartLocation() {
        return this.startLocation;
    }

    @Override
    public @NonNull LocationState getStartState() {
        return this.startLocation;
    }

    @Override
    public @NonNull ImmutableSet<@NonNull LocationState> getLocations() {
        return this.locations;
    }

    @Override
    public @NonNull ImmutableSet<@NonNull ActionTransition> getModelTransitions() {
        return this.transitions;
    }

    @Override
    public @NonNull ImmutableSet<@NonNull ActionTransition> getModelTransitions(@NonNull LocationState location) {
        return this.loc2trans.get((Object)location);
    }

    @Override
    public ImmutableSet<Action> getAlphabet() {
        return this.alphabet;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull ActionTransition> getModelTransitions(@NonNull LocationState location, @NonNull Action action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2trans.get((Object)location);
        for (ActionTransition transition : transitions) {
            if (!transition.getAction().equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("start: " + this.startLocation);
        joiner.add("locations:");
        for (LocationState location : this.getLocations()) {
            joiner.add(location.toString());
        }
        joiner.add("transitions:");
        for (ActionTransition transition : this.getModelTransitions()) {
            joiner.add(transition.toString());
        }
        joiner.add("");
        return joiner.toString();
    }

    public static abstract class ImmutableBuilder {
        protected LocationState startLocation;
        protected ImmutableSet<Action> alphabet;
        protected ImmutableSet<LocationState> locations;
        protected ImmutableSet<ActionTransition> transitions;
        protected ImmutableSetMultimap<LocationState, ActionTransition> loc2trans;
        protected ImmutableSet.Builder<LocationState> locationsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<ActionTransition> transitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<Action> alphabetBuilder = ImmutableSet.builder();
        protected ImmutableSetMultimap.Builder<LocationState, ActionTransition> loc2transBuilder = ImmutableSetMultimap.builder();

        public ImmutableBuilder addTransition(LocationState src, LocationState dst, Action action) {
            this.locationsBuilder.add((Object[])new LocationState[]{src, dst});
            this.alphabetBuilder.add((Object)action);
            ActionTransition transition = new ActionTransition(src, dst, action);
            this.transitionsBuilder.add((Object)transition);
            this.loc2transBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder setStartLocation(LocationState startLocation) {
            this.startLocation = startLocation;
            return this;
        }

        protected ImmutableBuilder addFromLtsModel(LtsModel model) {
            for (ActionTransition trans : model.getModelTransitions()) {
                this.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), trans.getAction());
            }
            this.setStartLocation((LocationState)model.getStartLocation());
            return this;
        }

        protected void baseBuild() {
            this.alphabet = this.alphabetBuilder.build();
            this.locations = this.locationsBuilder.build();
            this.transitions = this.transitionsBuilder.build();
            this.loc2trans = this.loc2transBuilder.build();
        }
    }
}

