/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.interfaces.system.properties.ActionDeterministic;
import statemachine.model.Util;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsBaseModel;
import statemachine.model.fsm.lts.LtsModel;

@NonNullByDefault
public final class LtsDetModel
extends LtsBaseModel
implements ActionDeterministic<LocationState, Action, ActionTransition> {
    private LtsDetModel(ImmutableBuilder builder) {
        super(builder);
        for (LocationState location : this.loc2trans.keySet()) {
            for (Action action : this.alphabet) {
                this.getSystemTransition(location, action);
            }
        }
    }

    public static LtsDetModel fromLtsModel(LtsModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromLtsModel(model);
        return builder.build();
    }

    @Override
    public Optional<ActionTransition> getSystemTransition(LocationState location, Action action) {
        ImmutableSet<@NonNull ActionTransition> transitions = this.getModelTransitions(location, action);
        return Util.getOptionalTransition(transitions);
    }

    public static final class ImmutableBuilder
    extends LtsBaseModel.ImmutableBuilder {
        public LtsDetModel build() {
            super.baseBuild();
            return new LtsDetModel(this);
        }
    }
}

