/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts;

import com.google.common.collect.ImmutableSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.interfaces.system.properties.ActionEnabledDeterministic;
import statemachine.model.Util;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsBaseModel;
import statemachine.model.fsm.lts.LtsModel;

@NonNullByDefault
public final class LtsEnabledDetModel
extends LtsBaseModel
implements ActionEnabledDeterministic<LocationState, Action, ActionTransition> {
    private LtsEnabledDetModel(ImmutableBuilder builder) {
        super(builder);
        for (LocationState location : this.loc2trans.keySet()) {
            for (Action action : this.alphabet) {
                this.getSystemTransition(location, action);
            }
        }
    }

    public static LtsEnabledDetModel fromLtsModel(LtsModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromLtsModel(model);
        return builder.build();
    }

    @Override
    public ActionTransition getSystemTransition(LocationState location, Action action) {
        ImmutableSet<@NonNull ActionTransition> transitions = this.getModelTransitions(location, action);
        return Util.getTheTransition(transitions, location.getName(), action.getName());
    }

    public static final class ImmutableBuilder
    extends LtsBaseModel.ImmutableBuilder {
        public LtsEnabledDetModel build() {
            super.baseBuild();
            return new LtsEnabledDetModel(this);
        }
    }
}

