/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts.format;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsDetModel;
import statemachine.model.fsm.lts.LtsEnabledDetModel;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class Aldebaran {
    public static LtsEnabledDetModel importLtsEnabledDetModel(List<String> lines) {
        return LtsEnabledDetModel.fromLtsModel(Aldebaran.importLtsNoneDetModel(lines));
    }

    public static LtsDetModel importLtsDetModel(List<String> lines) {
        return LtsDetModel.fromLtsModel(Aldebaran.importLtsNoneDetModel(lines));
    }

    public static LtsNonDetModel importLtsNoneDetModel(List<String> lines) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (String line : lines) {
            if (line.contains("des")) {
                int e1 = line.indexOf("(");
                int e2 = line.indexOf(",");
                String start = line.substring(e1 + 1, e2).trim();
                LocationState startLocation = new LocationState(start);
                builder.setStartLocation(startLocation);
                continue;
            }
            if (!line.contains(",")) continue;
            line = line.replace("(", "");
            line = line.replace(")", "");
            String[] pieces = line.split(",");
            String from = pieces[0].trim();
            String to = pieces[2].trim();
            String label = pieces[1].trim();
            CharMatcher matcher = CharMatcher.is((char)'\"');
            label = matcher.trimFrom((CharSequence)label);
            LocationState src = new LocationState(from);
            LocationState dst = new LocationState(to);
            Action action = new Action(label);
            builder.addTransition(src, dst, action);
        }
        return builder.build();
    }

    public static List<String> export(LtsModel model) {
        LinkedList<String> lines = new LinkedList<String>();
        ImmutableSet transitions = model.getModelTransitions();
        ImmutableSet locations = model.getLocations();
        LocationState startLocation = (LocationState)model.getStartLocation();
        HashMap<LocationState, Integer> loc2int = new HashMap<LocationState, Integer>();
        loc2int.put(startLocation, 0);
        int count = 1;
        for (LocationState location : locations) {
            if (location.equals(startLocation)) continue;
            loc2int.put(location, count);
            ++count;
        }
        lines.add("des (0," + transitions.size() + "," + locations.size() + ")");
        for (ActionTransition transition : model.getModelTransitions()) {
            lines.add("(" + loc2int.get(transition.getSource()) + ",\"" + transition.getAction().getName() + "\"," + loc2int.get(transition.getDestination()) + ")");
        }
        return lines;
    }
}

