/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts.format;

import java.util.LinkedList;
import java.util.List;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsDetModel;
import statemachine.model.fsm.lts.LtsEnabledDetModel;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class Dot {
    public static LtsEnabledDetModel importLtsEnabledDetModel(List<String> lines) {
        return LtsEnabledDetModel.fromLtsModel(Dot.importLtsNoneDetModel(lines));
    }

    public static LtsDetModel importLtsDetModel(List<String> lines) {
        return LtsDetModel.fromLtsModel(Dot.importLtsNoneDetModel(lines));
    }

    public static LtsNonDetModel importLtsNoneDetModel(List<String> lines) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (String line : lines) {
            String label;
            int e1;
            if (line.contains("color=\"red\"")) {
                e1 = line.indexOf(91);
                String start = line.substring(0, e1).trim();
                LocationState startLocation = new LocationState(start);
                builder.setStartLocation(startLocation);
            }
            if (line.contains("__start0") && !line.contains("label")) {
                e1 = line.indexOf(45);
                int e2 = line.indexOf(59);
                String start = line.substring(e1 + 2, e2).trim();
                LocationState startLocation = new LocationState(start);
                builder.setStartLocation(startLocation);
            }
            if (!line.contains("label") || !line.contains("->")) continue;
            if (line.contains("<")) {
                int beginIndex = line.indexOf("<");
                int lastIndex = line.lastIndexOf(">");
                label = line.substring(beginIndex, lastIndex);
                label = label.replaceAll("\\<[^>]*>", "").trim();
            } else {
                int startLabel = line.indexOf(34);
                int endLabel = line.lastIndexOf(34);
                label = line.substring(startLabel + 1, endLabel).trim();
            }
            int e12 = line.indexOf(45);
            int e2 = line.indexOf(91);
            String from = line.substring(0, e12).trim();
            String to = line.substring(e12 + 2, e2).trim();
            LocationState src = new LocationState(from);
            LocationState dst = new LocationState(to);
            Action action = new Action(label);
            builder.addTransition(src, dst, action);
        }
        return builder.build();
    }

    public static List<String> export(LtsModel model) {
        String indent = "    ";
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("digraph g {");
        lines.add("");
        lines.add(indent + "__start0 [label=\"\" shape=\"none\"]");
        lines.add("");
        for (LocationState location : model.getLocations()) {
            lines.add(indent + location + " [shape=\"circle\" label=\"" + location + "\"];");
        }
        for (ActionTransition transition : model.getModelTransitions()) {
            lines.add(indent + transition.getSource() + " -> " + transition.getDestination() + " [label=\"" + transition.getAction().getName() + "\"];");
        }
        lines.add("");
        lines.add(indent + "__start0 -> " + model.getStartLocation() + ";");
        lines.add("}");
        return lines;
    }
}

