/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts.format;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsDetModel;
import statemachine.model.fsm.lts.LtsEnabledDetModel;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class GML {
    public static LtsEnabledDetModel importLtsEnabledDetModel(List<String> lines) {
        return LtsEnabledDetModel.fromLtsModel(GML.importLtsNoneDetModel(lines));
    }

    public static LtsDetModel importLtsDetModel(List<String> lines) {
        return LtsDetModel.fromLtsModel(GML.importLtsNoneDetModel(lines));
    }

    public static LtsNonDetModel importLtsNoneDetModel(List<String> lines) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (String string : lines) {
        }
        return builder.build();
    }

    public static List<String> export(LtsModel model) {
        String indent1 = "    ";
        String indent2 = indent1 + indent1;
        LinkedList<String> lines = new LinkedList<String>();
        LocationState startLocation = (LocationState)model.getStartLocation();
        ImmutableSet locations = model.getLocations();
        HashMap<LocationState, Integer> loc2int = new HashMap<LocationState, Integer>();
        loc2int.put(startLocation, 0);
        int count = 1;
        for (LocationState location : locations) {
            if (location.equals(startLocation)) continue;
            loc2int.put(location, count);
            ++count;
        }
        lines.add("graph [");
        lines.add(indent1 + "directed 1");
        lines.add(indent1 + "id 0");
        for (LocationState location : model.getLocations()) {
            lines.add(indent1 + "node [");
            lines.add(indent2 + "id " + loc2int.get(location));
            lines.add(indent2 + "label \"" + location + "\"");
            lines.add(indent1 + "]");
        }
        for (ActionTransition transition : model.getModelTransitions()) {
            lines.add(indent1 + "edge [");
            lines.add(indent2 + "source " + loc2int.get(transition.getSource()));
            lines.add(indent2 + "target " + loc2int.get(transition.getDestination()));
            lines.add(indent2 + "label \"" + transition.getAction().getName() + "\"");
            lines.add(indent1 + "]");
        }
        lines.add("]");
        return lines;
    }
}

