/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts.format;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsDetModel;
import statemachine.model.fsm.lts.LtsEnabledDetModel;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;

public class GraphML {
    public static LtsEnabledDetModel importLtsEnabledDetModel(List<String> lines) {
        return LtsEnabledDetModel.fromLtsModel(GraphML.importLtsNoneDetModel(lines));
    }

    public static LtsDetModel importLtsDetModel(List<String> lines) {
        return LtsDetModel.fromLtsModel(GraphML.importLtsNoneDetModel(lines));
    }

    public static LtsNonDetModel importLtsNoneDetModel(List<String> lines) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (String string : lines) {
        }
        return builder.build();
    }

    public static List<String> export(LtsModel model) {
        String indent1 = "    ";
        String indent2 = indent1 + indent1;
        String indent3 = indent2 + indent1;
        MessageFormat fmtNode = new MessageFormat(indent2 + "<node id=\"{0}\"/>");
        MessageFormat fmtEdge = new MessageFormat(indent2 + "<edge  source=\"{0}\" target=\"{1}\">");
        MessageFormat fmtLabel = new MessageFormat(indent3 + "<data key=\"label\">{0}</data>");
        LinkedList<String> lines = new LinkedList<String>();
        LocationState startLocation = (LocationState)model.getStartLocation();
        lines.add("<graphml>");
        lines.add(indent1 + "<key id=\"label\"/>");
        lines.add(indent1 + "<graph id=\"G\" edgedefault=\"directed\">");
        for (LocationState location : model.getLocations()) {
            lines.add(fmtNode.format(new Object[]{location.toString()}));
        }
        String closeEdge = indent2 + "</edge>";
        for (ActionTransition transition : model.getModelTransitions()) {
            lines.add(fmtEdge.format(new Object[]{transition.getSource(), transition.getDestination()}));
            lines.add(fmtLabel.format(new Object[]{transition.getAction().getName()}));
            lines.add(closeEdge);
        }
        lines.add(indent1 + "</graph>");
        lines.add("</graphml>");
        return lines;
    }
}

