/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts.util;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import nl.ru.cs.tree.Tree;
import nl.ru.cs.tree.TreeNode;
import nl.ru.cs.tree.util.EdgeNode;
import statemachine.interfaces.system.properties.ActionDeterministic;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsDetModel;

public class Util {
    public static Tree<EdgeNode> getSpanningTreeLts(LtsDetModel detlts) {
        LocationState startLocation = detlts.getStartLocation();
        ImmutableSet<Action> actions = detlts.getAlphabet();
        return Util.getSpanningTreeLtsBase(detlts, startLocation, actions);
    }

    public static Tree<EdgeNode> getSpanningTreeLtsBase(ActionDeterministic<LocationState, Action, ActionTransition> detlts, LocationState startLocation, ImmutableSet<Action> actions) {
        HashSet<LocationState> locationsSeen = new HashSet<LocationState>();
        LinkedList<LocationState> locationsTodo = new LinkedList<LocationState>();
        HashMap<LocationState, TreeNode> location2node = new HashMap<LocationState, TreeNode>();
        TreeNode root = new TreeNode((Object)new EdgeNode("", startLocation.getName()));
        location2node.put(startLocation, root);
        locationsSeen.add(startLocation);
        locationsTodo.add(startLocation);
        while (!locationsTodo.isEmpty()) {
            LocationState location = (LocationState)locationsTodo.remove();
            TreeNode parentnode = (TreeNode)location2node.get(location);
            for (Action action : actions) {
                LocationState dest;
                Optional<ActionTransition> optTrans = detlts.getSystemTransition(location, action);
                if (!optTrans.isPresent() || locationsSeen.contains(dest = (LocationState)optTrans.get().getDestination())) continue;
                locationsSeen.add(dest);
                TreeNode childnode = new TreeNode((Object)new EdgeNode(action.getName(), dest.getName()));
                parentnode.addChild(childnode);
                location2node.put(dest, childnode);
                locationsTodo.add(dest);
            }
        }
        Tree tree = new Tree(root);
        return tree;
    }
}

