/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.lts.walker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.interfaces.system.walker.StepAction;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.fsm.lts.LtsNonDetModel;
import statemachine.model.fsm.lts.walker.LtsBaseWalker;

@NonNullByDefault
public class LtsNonDetRandomWalker
extends LtsBaseWalker<LtsNonDetModel>
implements StepAction<LocationState, Action> {
    private Random random;

    public LtsNonDetRandomWalker(LtsNonDetModel model, Random random) {
        super(model);
        this.random = random;
    }

    @Override
    public boolean checkActionPossible(Action action) {
        ImmutableSet<ActionTransition> possibleTransitions = ((LtsNonDetModel)this.model).getModelTransitions(this.currentLocation, action);
        return possibleTransitions.size() > 0;
    }

    @Override
    public void stepAction(Action action) {
        ImmutableSet<ActionTransition> possibleTransitions = ((LtsNonDetModel)this.model).getModelTransitions(this.currentLocation, action);
        int numTrans = possibleTransitions.size();
        if (numTrans > 1) {
            ImmutableList list = possibleTransitions.asList();
            int index = this.random.nextInt(numTrans);
            this.currentLocation = (LocationState)((ActionTransition)list.get(index)).getDestination();
        }
        if (numTrans == 1) {
            ActionTransition t = (ActionTransition)possibleTransitions.iterator().next();
            this.currentLocation = (LocationState)t.getDestination();
        }
    }
}

