/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.mealy;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.StringJoiner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.MealyTransition;
import statemachine.model.fsm.mealy.MealyModel;

@NonNullByDefault
public abstract class MealyBaseModel
implements MealyModel {
    protected final ImmutableSet<InputAction> inputalphabet;
    protected final ImmutableSet<OutputAction> outputalphabet;
    private final LocationState startLocation;
    private final ImmutableSet<LocationState> locations;
    private final ImmutableSet<MealyTransition> transitions;
    protected final ImmutableSetMultimap<LocationState, MealyTransition> loc2trans;

    protected MealyBaseModel(ImmutableBuilder builder) {
        this.inputalphabet = builder.inputalphabet;
        this.outputalphabet = builder.outputalphabet;
        this.startLocation = builder.startLocation;
        this.locations = builder.locations;
        this.transitions = builder.transitions;
        this.loc2trans = builder.loc2trans;
    }

    @Override
    public @NonNull LocationState getStartLocation() {
        return this.startLocation;
    }

    @Override
    public @NonNull LocationState getStartState() {
        return this.startLocation;
    }

    @Override
    public ImmutableSet<LocationState> getLocations() {
        return this.locations;
    }

    @Override
    public ImmutableSet<MealyTransition> getModelTransitions() {
        return this.transitions;
    }

    @Override
    public ImmutableSet<MealyTransition> getModelTransitions(LocationState location) {
        return this.loc2trans.get((Object)location);
    }

    @Override
    public ImmutableSet<InputAction> getInputAlphabet() {
        return this.inputalphabet;
    }

    @Override
    public ImmutableSet<OutputAction> getOutputAlphabet() {
        return this.outputalphabet;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull MealyTransition> getModelTransitions(LocationState location, InputAction action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2trans.get((Object)location);
        for (MealyTransition transition : transitions) {
            if (!transition.getInput().equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("start: " + this.startLocation);
        joiner.add("locations:");
        for (LocationState location : this.getLocations()) {
            joiner.add(location.toString());
        }
        joiner.add("transitions:");
        for (MealyTransition transition : this.getModelTransitions()) {
            joiner.add(transition.toString());
        }
        joiner.add("");
        return joiner.toString();
    }

    public static abstract class ImmutableBuilder {
        protected ImmutableSet<InputAction> inputalphabet;
        protected ImmutableSet<OutputAction> outputalphabet;
        protected LocationState startLocation;
        protected ImmutableSet<LocationState> locations;
        protected ImmutableSet<MealyTransition> transitions;
        protected ImmutableSetMultimap<LocationState, MealyTransition> loc2trans;
        protected ImmutableSet.Builder<LocationState> locationsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<MealyTransition> transitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<InputAction> inputalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<OutputAction> outputalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSetMultimap.Builder<LocationState, MealyTransition> loc2transBuilder = ImmutableSetMultimap.builder();

        public ImmutableBuilder addTransition(LocationState src, LocationState dst, InputAction input, OutputAction output) {
            this.locationsBuilder.add((Object[])new LocationState[]{src, dst});
            this.inputalphabetBuilder.add((Object)input);
            this.outputalphabetBuilder.add((Object)output);
            MealyTransition transition = new MealyTransition(src, dst, input, output);
            this.transitionsBuilder.add((Object)transition);
            this.loc2transBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder setStartLocation(LocationState startLocation) {
            this.startLocation = startLocation;
            return this;
        }

        protected ImmutableBuilder addFromMealyModel(MealyModel model) {
            for (MealyTransition trans : model.getModelTransitions()) {
                this.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), trans.getInput(), trans.getOutput());
            }
            this.setStartLocation((LocationState)model.getStartLocation());
            return this;
        }

        protected void baseBuild() {
            this.inputalphabet = this.inputalphabetBuilder.build();
            this.outputalphabet = this.outputalphabetBuilder.build();
            this.locations = this.locationsBuilder.build();
            this.transitions = this.transitionsBuilder.build();
            this.loc2trans = this.loc2transBuilder.build();
        }
    }
}

