/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.mealy;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.interfaces.system.properties.InputDeterministic;
import statemachine.model.Util;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.MealyTransition;
import statemachine.model.fsm.mealy.MealyBaseModel;
import statemachine.model.fsm.mealy.MealyModel;

@NonNullByDefault
public class MealyDetModel
extends MealyBaseModel
implements MealyModel,
InputDeterministic<LocationState, InputAction, MealyTransition> {
    private MealyDetModel(ImmutableBuilder builder) {
        super(builder);
        for (LocationState location : this.loc2trans.keySet()) {
            for (InputAction action : this.inputalphabet) {
                this.getSystemTransition(location, action);
            }
        }
    }

    public static MealyDetModel fromMealyModel(MealyModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromMealyModel(model);
        return builder.build();
    }

    @Override
    public Optional<MealyTransition> getSystemTransition(LocationState location, InputAction action) {
        ImmutableSet<MealyTransition> transitions = this.getModelTransitions(location, action);
        return Util.getOptionalTransition(transitions);
    }

    public static final class ImmutableBuilder
    extends MealyBaseModel.ImmutableBuilder {
        public MealyDetModel build() {
            super.baseBuild();
            return new MealyDetModel(this);
        }
    }
}

