/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.mealy;

import statemachine.model.fsm.mealy.MealyBaseModel;
import statemachine.model.fsm.mealy.MealyModel;
import statemachine.model.fsm.mealy.file.Import;

public class MealyNonDetModel
extends MealyBaseModel {
    static int counter = 0;

    private MealyNonDetModel(ImmutableBuilder builder) {
        super(builder);
    }

    public static MealyNonDetModel fromMealyModel(MealyModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromMealyModel(model);
        return builder.build();
    }

    public static void printSimpleStatistics(String filename) {
        MealyNonDetModel mealyModel = Import.dot2MealyModel(filename);
        int num_inputs = mealyModel.getInputAlphabet().size();
        int num_locations = mealyModel.getLocations().size();
        int num_outputs = mealyModel.getOutputAlphabet().size();
        int num_trans = mealyModel.getModelTransitions().size();
        String format = "states:%1$-10.10s  inputs:%2$-10.10s outputs:%3$-10.10s  transitions:%4$-10.10s";
        System.out.println(String.format(format, num_locations, num_inputs, num_outputs, num_trans));
    }

    public static void printStatistics(String filename, String name) {
        MealyNonDetModel mealyModel = Import.dot2MealyModel(filename);
        int num_inputs = mealyModel.getInputAlphabet().size();
        int num_locations = mealyModel.getLocations().size();
        int num_outputs = mealyModel.getOutputAlphabet().size();
        int result = num_inputs * num_locations;
        int num_trans = mealyModel.getModelTransitions().size();
        if (result != num_trans) {
            System.err.println(String.format("problem: model %s :  num_inputs(%d) * num_locations(%d) = %d != num_trans(%d)  ", name, num_inputs, num_locations, result, num_trans));
        }
        String formatRow = "||%1$-60.60s || %2$10.10s || %3$10.10s/%4$-10.10s ||  %5$10.10s ||";
        String formatHeader = "||!%1$-60.60s ||! %2$10.10s ||! %3$10.10s/%4$-10.10s ||!  %5$10.10s ||";
        if (counter % 1000 == 0) {
            System.out.println(String.format(formatHeader, "model", "states", "inputs", "outputs", "transitions"));
        }
        System.out.println(String.format(formatRow, name, num_locations, num_inputs, num_outputs, num_trans));
        ++counter;
    }

    public static final class ImmutableBuilder
    extends MealyBaseModel.ImmutableBuilder {
        public MealyNonDetModel build() {
            super.baseBuild();
            return new MealyNonDetModel(this);
        }
    }
}

