/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.mealy.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.automata.transout.impl.compact.CompactMealyTransition;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.MealyTransition;
import statemachine.model.fsm.mealy.MealyModel;
import statemachine.model.fsm.mealy.MealyNonDetModel;

public class AutomataLib {
    public static MealyNonDetModel convert2statemachinelibMealy(CompactMealy<String, String> model) {
        MealyNonDetModel.ImmutableBuilder builder = new MealyNonDetModel.ImmutableBuilder();
        Integer startState = model.getInitialState();
        builder.setStartLocation(new LocationState(startState.toString()));
        Collection states = model.getStates();
        Alphabet inputAlphabet = model.getInputAlphabet();
        for (Integer state : states) {
            for (String input : inputAlphabet) {
                CompactMealyTransition t = (CompactMealyTransition)model.getTransition(state, (Object)input);
                if (t == null) continue;
                String output = (String)t.getOutput();
                Integer destination = model.getSuccessor((Object)t);
                InputAction in = new InputAction(input);
                OutputAction out = new OutputAction(output);
                LocationState src = new LocationState(state.toString());
                LocationState dst = new LocationState(destination.toString());
                builder.addTransition(src, dst, in, out);
            }
        }
        return builder.build();
    }

    public static CompactMealy<String, String> convert2automatalibMealy(MealyModel model) {
        ArrayList<String> inputs = new ArrayList<String>();
        for (InputAction input : model.getInputAlphabet()) {
            inputs.add(input.getName());
        }
        Alphabet inputAlphabet = Alphabets.fromList(inputs);
        CompactMealy machine = new CompactMealy(inputAlphabet);
        HashMap<LocationState, Integer> statelib2autolibLocation = new HashMap<LocationState, Integer>();
        LocationState startLocation = (LocationState)model.getStartLocation();
        Integer startState = (Integer)machine.addInitialState();
        statelib2autolibLocation.put(startLocation, startState);
        for (LocationState l : model.getLocations()) {
            if (l == startLocation) continue;
            Integer state = (Integer)machine.addState();
            statelib2autolibLocation.put(l, state);
        }
        for (MealyTransition t : model.getModelTransitions()) {
            Integer source = (Integer)statelib2autolibLocation.get(t.getSource());
            Integer destination = (Integer)statelib2autolibLocation.get(t.getDestination());
            machine.addTransition((Object)source, (Object)t.getInput().getName(), (Object)destination, (Object)t.getOutput().getName());
        }
        return machine;
    }
}

