/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.mealy.conversion;

import com.google.common.collect.HashMultimap;
import java.util.HashSet;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.MealyTransition;
import statemachine.model.fsm.ia.IaNonDetModel;
import statemachine.model.fsm.mealy.MealyModel;
import statemachine.model.fsm.moore.MooreNonDetModel;

public class Conversion {
    public static MooreNonDetModel Mealy2MooreNonDetModel(MealyModel mealy) {
        String locationname;
        MooreNonDetModel.ImmutableBuilder builder = new MooreNonDetModel.ImmutableBuilder();
        LocationState mealyStartLocation = (LocationState)mealy.getStartLocation();
        HashMultimap mealyloc2mooreloc = HashMultimap.create();
        for (MealyTransition transition : mealy.getModelTransitions()) {
            locationname = "_" + ((LocationState)transition.getDestination()).getName() + "_" + transition.getOutput().getName();
            LocationState mooreloc = new LocationState(locationname);
            mealyloc2mooreloc.put(transition.getDestination(), (Object)mooreloc);
            builder.addOutput(mooreloc, transition.getOutput());
        }
        LocationState mooreStartLocation = (LocationState)mealyloc2mooreloc.get((Object)mealyStartLocation).iterator().next();
        builder.setStartLocation(mooreStartLocation);
        for (MealyTransition transition : mealy.getModelTransitions()) {
            locationname = "_" + ((LocationState)transition.getDestination()).getName() + "_" + transition.getOutput().getName();
            LocationState dst = new LocationState(locationname);
            for (LocationState src : mealyloc2mooreloc.get(transition.getSource())) {
                builder.addTransition(src, dst, transition.getInput());
            }
        }
        return builder.build();
    }

    public static IaNonDetModel Mealy2IaNonDetModel(MealyModel mealy) {
        IaNonDetModel.ImmutableBuilder builder = new IaNonDetModel.ImmutableBuilder();
        builder.setStartLocation((LocationState)mealy.getStartLocation());
        HashSet<String> seen = new HashSet<String>();
        for (MealyTransition transition : mealy.getModelTransitions()) {
            String outputkey;
            InputAction input = transition.getInput();
            OutputAction output = transition.getOutput();
            LocationState startLocation = (LocationState)transition.getSource();
            LocationState endLocation = (LocationState)transition.getDestination();
            LocationState midLocation = new LocationState(output.getName() + "_" + endLocation.getName());
            String inputkey = midLocation.getName() + "--" + endLocation.getName() + "--?" + input.getName();
            if (!seen.contains(inputkey)) {
                builder.addInputTransition(startLocation, midLocation, input);
                seen.add(inputkey);
            }
            if (seen.contains(outputkey = midLocation.getName() + "--" + endLocation.getName() + "--!" + output.getName())) continue;
            builder.addOutputTransition(midLocation, endLocation, output);
            seen.add(outputkey);
        }
        return builder.build();
    }
}

