/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.mealy.conversion;

import org.javatuples.Pair;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.elements.transition.MealyTransition;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;
import statemachine.model.fsm.mealy.MealyModel;
import statemachine.model.fsm.mealy.MealyNonDetModel;
import statemachine.model.fsm.mealy.conversion.TransitionLabelFormatter;
import statemachine.model.fsm.mealy.conversion.TransitionLabelParser;

public class LtsZip {
    public static TransitionLabelFormatter defaultTransitionLabelFormatter = (input, output) -> input.getName() + "/" + output.getName();
    public static TransitionLabelParser defaultTransitionLabelParser = new TransitionLabelParser(){

        @Override
        public Pair<InputAction, OutputAction> apply(String label) {
            String[] parts = label.split("/");
            InputAction input = new InputAction(parts[0].trim());
            OutputAction output = new OutputAction(parts[1].trim());
            return new Pair((Object)input, (Object)output);
        }
    };

    public static LtsNonDetModel zipMealy2Lts(MealyModel model, TransitionLabelFormatter transitionFormatter) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (MealyTransition trans : model.getModelTransitions()) {
            String label = transitionFormatter.apply(trans.getInput(), trans.getOutput());
            Action action = new Action(label);
            builder.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), action);
        }
        builder.setStartLocation((LocationState)model.getStartLocation());
        return builder.build();
    }

    public static LtsNonDetModel zipMealy2Lts(MealyModel model) {
        return LtsZip.zipMealy2Lts(model, defaultTransitionLabelFormatter);
    }

    public static MealyNonDetModel unzipLts2Mealy(LtsModel model, TransitionLabelParser labelParser) {
        MealyNonDetModel.ImmutableBuilder builder = new MealyNonDetModel.ImmutableBuilder();
        for (ActionTransition trans : model.getModelTransitions()) {
            String label = trans.getAction().getName();
            Pair<InputAction, OutputAction> input_output = labelParser.apply(label);
            InputAction input = (InputAction)input_output.getValue0();
            OutputAction output = (OutputAction)input_output.getValue1();
            builder.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), input, output);
        }
        builder.setStartLocation((LocationState)model.getStartLocation());
        return builder.build();
    }

    public static MealyNonDetModel unzipLts2Mealy(LtsModel model) {
        return LtsZip.unzipLts2Mealy(model, defaultTransitionLabelParser);
    }
}

