/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.mealy.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import nl.ru.cs.tree.Tree;
import nl.ru.cs.tree.TreeNode;
import nl.ru.cs.tree.util.EdgeNode;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.MealyTransition;
import statemachine.model.fsm.mealy.MealyDetModel;
import statemachine.model.fsm.mealy.util.TraceDiff;
import statemachine.util.LocationPair;

public class Util {
    public static Tree<EdgeNode> getSpanningTreeMealy(MealyDetModel detlts) {
        HashSet<LocationState> locationsSeen = new HashSet<LocationState>();
        LinkedList<LocationState> locationsTodo = new LinkedList<LocationState>();
        HashMap<LocationState, TreeNode> location2node = new HashMap<LocationState, TreeNode>();
        LocationState startLocation = detlts.getStartLocation();
        ImmutableSet<InputAction> actions = detlts.getInputAlphabet();
        TreeNode root = new TreeNode((Object)new EdgeNode("", startLocation.getName()));
        location2node.put(startLocation, root);
        locationsSeen.add(startLocation);
        locationsTodo.add(startLocation);
        while (!locationsTodo.isEmpty()) {
            LocationState location = (LocationState)locationsTodo.remove();
            TreeNode parentnode = (TreeNode)location2node.get(location);
            for (InputAction action : actions) {
                LocationState dest;
                Optional<MealyTransition> optTrans = detlts.getSystemTransition(location, action);
                if (!optTrans.isPresent() || locationsSeen.contains(dest = (LocationState)optTrans.get().getDestination())) continue;
                locationsSeen.add(dest);
                TreeNode childnode = new TreeNode((Object)new EdgeNode(action.getName(), dest.getName()));
                parentnode.addChild(childnode);
                location2node.put(dest, childnode);
                locationsTodo.add(dest);
            }
        }
        Tree tree = new Tree(root);
        return tree;
    }

    public static TraceDiff compare(MealyDetModel machine1, MealyDetModel machine2) {
        return Util.compare(machine1, machine2, machine1.getInputAlphabet());
    }

    public static TraceDiff compare(MealyDetModel machine1, MealyDetModel machine2, ImmutableSet<InputAction> inputAlphabet) {
        LocationState startLoc1 = machine1.getStartLocation();
        LocationState startLoc2 = machine2.getStartLocation();
        LocationPair startPair = new LocationPair(startLoc1, startLoc2);
        HashMap<LocationPair, Link> statePair2actionOnIncomingTransition = new HashMap<LocationPair, Link>();
        HashSet<LocationPair> seenStatePairs = new HashSet<LocationPair>();
        LinkedList<LocationPair> locationPairsTodo = new LinkedList<LocationPair>();
        seenStatePairs.add(startPair);
        locationPairsTodo.add(startPair);
        while (!locationPairsTodo.isEmpty()) {
            LocationPair currentLocPair = (LocationPair)locationPairsTodo.remove();
            for (InputAction input : inputAlphabet) {
                OutputAction out2;
                OutputAction out1;
                Optional<MealyTransition> trans1 = machine1.getSystemTransition(currentLocPair.left, input);
                Optional<MealyTransition> trans2 = machine2.getSystemTransition(currentLocPair.right, input);
                if (trans1.isPresent() != trans2.isPresent()) {
                    if (trans1.isPresent()) {
                        out1 = trans1.get().getOutput();
                        out2 = null;
                    } else {
                        out2 = trans2.get().getOutput();
                        out1 = null;
                    }
                    return Util.getTraceDiff(input, out1, out2, machine1, statePair2actionOnIncomingTransition, startPair, currentLocPair);
                }
                if (!trans1.isPresent()) continue;
                out1 = trans1.get().getOutput();
                if (out1.equals(out2 = trans2.get().getOutput())) {
                    LocationPair destinationPair = new LocationPair((LocationState)trans1.get().getDestination(), (LocationState)trans2.get().getDestination());
                    if (seenStatePairs.contains(destinationPair)) continue;
                    seenStatePairs.add(destinationPair);
                    locationPairsTodo.add(destinationPair);
                    statePair2actionOnIncomingTransition.put(destinationPair, new Link(currentLocPair, input));
                    continue;
                }
                return Util.getTraceDiff(input, out1, out2, machine1, statePair2actionOnIncomingTransition, startPair, currentLocPair);
            }
        }
        return null;
    }

    public static List<InputAction> getInputs(Map<LocationPair, Link> statePair2actionOnIncomingTransition, LocationPair startPair, LocationPair endPair) {
        ArrayList<InputAction> inputs = new ArrayList<InputAction>();
        LocationPair currentPair = endPair;
        while (!currentPair.equals(startPair)) {
            Link prevPairAndInput = statePair2actionOnIncomingTransition.get(currentPair);
            inputs.add(prevPairAndInput.input);
            currentPair = prevPairAndInput.previousLocationPair;
        }
        Collections.reverse(inputs);
        return inputs;
    }

    public static List<OutputAction> getOutputs(MealyDetModel machine, List<InputAction> inputs) {
        ArrayList<OutputAction> outputs = new ArrayList<OutputAction>();
        LocationState location = machine.getStartLocation();
        for (InputAction input : inputs) {
            MealyTransition transition = machine.getSystemTransition(location, input).get();
            outputs.add(transition.getOutput());
            location = (LocationState)transition.getDestination();
        }
        return outputs;
    }

    public static TraceDiff getTraceDiff(InputAction input, OutputAction out1, OutputAction out2, MealyDetModel machine, Map<LocationPair, Link> statePair2actionOnIncomingTransition, LocationPair startPair, LocationPair endPair) {
        List<InputAction> inputs = Util.getInputs(statePair2actionOnIncomingTransition, startPair, endPair);
        List<OutputAction> outputs = Util.getOutputs(machine, inputs);
        return new TraceDiff(inputs, outputs, input, out1, out2);
    }

    static class Link {
        public LocationPair previousLocationPair;
        public InputAction input;

        public Link(LocationPair previousLocationPair, InputAction input) {
            this.previousLocationPair = previousLocationPair;
            this.input = input;
        }
    }
}

