/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.mealy.walker;

import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.interfaces.system.walker.StepInputGetOptionalOutput;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.MealyTransition;
import statemachine.model.fsm.mealy.MealyDetModel;
import statemachine.model.fsm.mealy.walker.MealyBaseWalker;

@NonNullByDefault
public class MealyDetWalker
extends MealyBaseWalker<MealyDetModel>
implements StepInputGetOptionalOutput<LocationState, InputAction, OutputAction> {
    public MealyDetWalker(MealyDetModel model) {
        super(model);
    }

    @Override
    public boolean checkInputPossible(InputAction action) {
        Optional<MealyTransition> optTransition = ((MealyDetModel)this.model).getSystemTransition(this.currentLocation, action);
        return optTransition.isPresent();
    }

    @Override
    public Optional<OutputAction> stepInput(InputAction action) {
        Optional<MealyTransition> optTransition = ((MealyDetModel)this.model).getSystemTransition(this.currentLocation, action);
        if (optTransition.isPresent()) {
            MealyTransition transition = optTransition.get();
            this.currentLocation = (LocationState)transition.getDestination();
            return Optional.of(transition.getOutput());
        }
        return Optional.empty();
    }
}

