/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.moore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.HashSet;
import java.util.StringJoiner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.moore.MooreModel;

@NonNullByDefault
public abstract class MooreBaseModel
implements MooreModel {
    protected final ImmutableSet<InputAction> inputalphabet;
    protected final ImmutableSet<OutputAction> outputalphabet;
    private final LocationState startLocation;
    private final ImmutableSet<LocationState> locations;
    private final ImmutableSet<InputTransition> transitions;
    protected final ImmutableSetMultimap<LocationState, InputTransition> loc2trans;
    protected ImmutableMap<LocationState, OutputAction> loc2output;

    protected MooreBaseModel(ImmutableBuilder builder) {
        this.inputalphabet = builder.inputalphabet;
        this.outputalphabet = builder.outputalphabet;
        this.startLocation = builder.startLocation;
        this.locations = builder.locations;
        this.transitions = builder.transitions;
        this.loc2trans = builder.loc2trans;
        this.loc2output = builder.loc2output;
    }

    @Override
    public @NonNull LocationState getStartLocation() {
        return this.startLocation;
    }

    @Override
    public @NonNull LocationState getStartState() {
        return this.startLocation;
    }

    @Override
    public ImmutableSet<LocationState> getLocations() {
        return this.locations;
    }

    @Override
    public ImmutableSet<InputTransition> getModelTransitions() {
        return this.transitions;
    }

    @Override
    public ImmutableSet<InputTransition> getModelTransitions(LocationState location) {
        return this.loc2trans.get((Object)location);
    }

    @Override
    public ImmutableSet<InputAction> getInputAlphabet() {
        return this.inputalphabet;
    }

    @Override
    public ImmutableSet<OutputAction> getOutputAlphabet() {
        return this.outputalphabet;
    }

    @Override
    public ImmutableSet<InputTransition> getModelTransitions(LocationState location, InputAction action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        ImmutableSet transitions = this.loc2trans.get((Object)location);
        for (InputTransition transition : transitions) {
            if (!transition.getInput().equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    @Override
    public OutputAction getOutputAt(LocationState location) {
        return (OutputAction)this.loc2output.get((Object)location);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("start: " + this.startLocation);
        joiner.add("locations:");
        for (LocationState location : this.getLocations()) {
            joiner.add(location.toString() + ": !" + ((OutputAction)this.loc2output.get((Object)location)).getName());
        }
        joiner.add("transitions:");
        for (InputTransition transition : this.getModelTransitions()) {
            joiner.add(transition.toString());
        }
        joiner.add("");
        return joiner.toString();
    }

    public static abstract class ImmutableBuilder {
        protected ImmutableSet<InputAction> inputalphabet;
        protected ImmutableSet<OutputAction> outputalphabet;
        protected LocationState startLocation;
        protected ImmutableSet<LocationState> locations;
        protected ImmutableSet<InputTransition> transitions;
        protected ImmutableSetMultimap<LocationState, InputTransition> loc2trans;
        protected ImmutableMap<LocationState, OutputAction> loc2output;
        protected ImmutableSet.Builder<LocationState> locationsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<InputTransition> transitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<InputAction> inputalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<OutputAction> outputalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSetMultimap.Builder<LocationState, InputTransition> loc2transBuilder = ImmutableSetMultimap.builder();
        protected ImmutableMap.Builder<LocationState, OutputAction> loc2outputBuilder = ImmutableMap.builder();
        HashSet<LocationState> locationsDone = new HashSet();

        public ImmutableBuilder addTransition(LocationState src, LocationState dst, InputAction input) {
            this.locationsBuilder.add((Object[])new LocationState[]{src, dst});
            this.inputalphabetBuilder.add((Object)input);
            InputTransition transition = new InputTransition(src, dst, input);
            this.transitionsBuilder.add((Object)transition);
            this.loc2transBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder setStartLocation(LocationState startLocation) {
            this.startLocation = startLocation;
            return this;
        }

        protected ImmutableBuilder addOutput(LocationState src, OutputAction output) {
            this.locationsBuilder.add((Object)src);
            this.outputalphabetBuilder.add((Object)output);
            if (!this.locationsDone.contains(src)) {
                this.loc2outputBuilder.put((Object)src, (Object)output);
                this.locationsDone.add(src);
            }
            return this;
        }

        protected ImmutableBuilder addFromMooreModel(MooreModel model) {
            for (InputTransition trans : model.getModelTransitions()) {
                this.addTransition((LocationState)trans.getSource(), (LocationState)trans.getDestination(), trans.getInput());
            }
            for (LocationState location : model.getLocations()) {
                this.addOutput(location, (OutputAction)model.getOutputAt(location));
            }
            this.setStartLocation((LocationState)model.getStartLocation());
            return this;
        }

        protected void baseBuild() {
            this.inputalphabet = this.inputalphabetBuilder.build();
            this.outputalphabet = this.outputalphabetBuilder.build();
            this.locations = this.locationsBuilder.build();
            this.transitions = this.transitionsBuilder.build();
            this.loc2trans = this.loc2transBuilder.build();
            this.loc2output = this.loc2outputBuilder.build();
        }
    }
}

