/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.moore;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import statemachine.interfaces.system.properties.InputDeterministic;
import statemachine.model.Util;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.moore.MooreBaseModel;
import statemachine.model.fsm.moore.MooreModel;

public class MooreDetModel
extends MooreBaseModel
implements InputDeterministic<LocationState, InputAction, InputTransition> {
    private MooreDetModel(ImmutableBuilder builder) {
        super(builder);
        for (LocationState location : this.loc2trans.keySet()) {
            for (InputAction action : this.inputalphabet) {
                this.getSystemTransition(location, action);
            }
        }
    }

    public static MooreDetModel fromMooreModel(MooreModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromMooreModel(model);
        return builder.build();
    }

    @Override
    public Optional<InputTransition> getSystemTransition(LocationState location, InputAction action) {
        ImmutableSet<@NonNull InputTransition> transitions = this.getModelTransitions(location, action);
        return Util.getOptionalTransition(transitions);
    }

    public static final class ImmutableBuilder
    extends MooreBaseModel.ImmutableBuilder {
        @Override
        public ImmutableBuilder addOutput(LocationState src, OutputAction output) {
            super.addOutput(src, output);
            return this;
        }

        public MooreDetModel build() {
            super.baseBuild();
            return new MooreDetModel(this);
        }
    }
}

