/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.moore;

import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.fsm.moore.MooreBaseModel;
import statemachine.model.fsm.moore.MooreModel;
import statemachine.model.fsm.moore.file.Import;

public class MooreNonDetModel
extends MooreBaseModel {
    private MooreNonDetModel(ImmutableBuilder builder) {
        super(builder);
    }

    public static MooreNonDetModel fromMooreModel(MooreModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromMooreModel(model);
        return builder.build();
    }

    public static void printSimpleStatistics(String filename) {
        MooreNonDetModel nfaModel = Import.dot2MooreModel(filename);
        int num_inputs = nfaModel.getInputAlphabet().size();
        int num_locations = nfaModel.getLocations().size();
        int num_outputs = nfaModel.getOutputAlphabet().size();
        int num_trans = nfaModel.getModelTransitions().size();
        String format = "states:%1$-10.10s  inputs:%2$-10.10s outputs:%3$-10.10s  transitions:%4$-10.10s";
        System.out.println(String.format(format, num_locations, num_inputs, num_outputs, num_trans));
    }

    public static final class ImmutableBuilder
    extends MooreBaseModel.ImmutableBuilder {
        @Override
        public ImmutableBuilder addOutput(LocationState src, OutputAction output) {
            super.addOutput(src, output);
            return this;
        }

        public MooreNonDetModel build() {
            super.baseBuild();
            return new MooreNonDetModel(this);
        }
    }
}

